/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.object.bezier;

import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;


/**
 * Implementation of a bezier for fermion lines.
 *
 * @since 2.0
 */
public class JaxoSBezier extends JaxoDashBezier {
    private static final long serialVersionUID = 314159L;

    /** {@inheritDoc} */
    @Override
    public final boolean isCopy(final JaxoObject comp) {
        boolean isCopy = false;

        if (comp instanceof JaxoSBezier) {
            isCopy = super.isCopy(comp);
        }

        return isCopy;
    }

    /** {@inheritDoc} */
    protected float[] strokeDashes() {
        return new float[]{getDash()};
    }

    /** {@inheritDoc} */
    @Override
    public void setPreferences() {
        super.setPreferences();
        setDash(SCALAR_DASH);
    }

    /** {@inheritDoc} */
    public void prepareEditPanel(final JaxoObjectEditPanel editPanel) {
        editPanel.add4PointsPanel(getPoints(), 0, 0, 2);
        //editPanel.addDoubleLinePanel(bezier, 4, 0);
        editPanel.addStrokePanel(getStrokeWidth(), 0, 1);
        editPanel.addDashPanel(getDash(), 1, 1);
        editPanel.addLineColorPanel(getColor(), 2, 1);
        //editPanel.addArrowPanel(isPaintArrow(), isFlip(), false, false, 0, 2);
        //editPanel.addArrowPositionPanel(getArrowPosition(), 1, 2);
        editPanel.addArrowPanel(isPaintArrow(), isFlip(), getArrowPosition(), 0, 2);
        editPanel.addArrowOptionsEditPanel(getArrow(), 1, 2);

        editPanel.setTitleAndIcon("Scalar_bezier_parameters", "beziers.png");
    }

    /** {@inheritDoc} */
    protected String getIdentifier() {
        return "%JaxoID:SBez";
    }
}
