/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.object;


/**
 * An interface for objects that have wiggles.
 *
 * @since 2.0
 */
public interface JaxoWiggleObject {
    /**
     * Sets the number of wiggles of this WiggleObject.
     *
     * @param wiggles The number of wiggles.
     */
    void setWiggles(int wiggles);

    /**
     * Gets the number of wiggles of this WiggleObject.
     *
     * @return The number of wiggles.
     */
    int getWiggles();

    /**
     * Sets the amplitude of this WiggleObject.
     *
     * @param amp The amplitude to set.
     */
    void setAmp(int amp);

    /**
     * Gets the amplitude of this WiggleObject.
     *
     * @return The amplitude.
     */
    int getAmp();

    /**
     * Gets the current frequency (number of wiggles per unit length)
     * of this WiggleObject.
     *
     * @return The frequency.
     */
    float getFrequency();

    /** Sets the number of wiggles from the current frequency. */
    void setWigglesFromFrequency();

    /**
     * Sets the frequency to the given value
     * and derives the number of wiggles from it.
     *
     * @param frequency The frequency to set.
     */
    void setWigglesFromFrequency(float frequency);

    /**
     * Sets the number of wiggles to the given value and derives
     * the frequency from it.
     *
     * @param wiggles The number of wiggles to set.
     */
    void setFrequencyFromWiggles(int wiggles);
}
