/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.object;


/**
 * An interface for objects that can be symmetrized.
 *
 * @since 2.0
 */
public interface JaxoSymmetricObject {
    /**
     * Returns the symmetric property of this object.
     *
     * @return The symmetric property of this object.
     */
    boolean isSymmetric();

    /**
     * Sets the symmetric property of this object.
     *
     * @param symmetric The symmetric property of this object.
     */
    void setSymmetric(boolean symmetric);
}
