/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.object;

import java.awt.Rectangle;

import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

/**
 * A handle for a JaxoObject.
 *
 * @since 2.0
 */
public interface JaxoHandle {

    /**
     * Paint the handle at a given position.
     *
     * @param g2 The graphics context to paint to.
     * @param x The x position of the handle.
     * @param y The y position of the handle.
     * @param marked True if the handle should be painted as marked.
     *  A marked handle is one that has been selected, eg for an edit operation.
     * @param secondary True if this is a secondary handle. A secondary handle
     *  is one that cannot be selected in the current context.
     */
    void paint(JaxoGraphics2D g2, int x, int y, boolean marked, boolean secondary);

    /**
     * Determines whether the given point is contained in this handle.
     *
     * @param handleX The x position of the handle.
     * @param handleY The y position of the handle.
     * @param x The x position of the point to check.
     * @param y The y position of the point to check.
     * @return True if the handle encloses the point, false otherwise.
     */
    boolean contains(int handleX, int handleY, int x, int y);

    /**
     * Return an enclosing Rectangle that completely contains this handle
     *  at the given position.
     *
     * @param x the x position of this handle.
     * @param y the x position of this handle.
     * @return the bounding box of this handle.
     */
    Rectangle getBounds(int x, int y);
}
