/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.object;

import java.awt.Color;


/**
 * An interface for objects that have a fill color.
 *
 * @since 2.0
 */
public interface JaxoFillColorObject {
    /**
     * Returns the fill color of this object.
     *
     * @return The fillcolor.
     */
    Color getFillColor();

    /**
     * Sets the fill color of this object.
     *
     * @param color The fillcolor.
     */
    void setFillColor(Color color);

    /**
     * Determines if the object is actually filled.
     *
     * @return True if the fillColor is used.
     */
    boolean isFilled();

    /**
     * Determines if the object should be filled.
     *
     * @param value True if the fillcolor should be used.
     */
    void setFilled(boolean value);
}
