/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.logging;

import java.util.logging.ConsoleHandler;
import java.util.logging.Level;


/**
 * A ConsoleHandler for log records.
 * Logs are written to Standard Error.
 *
 * @since 2.0
 */
public final class JaxoConsoleHandler extends ConsoleHandler {

    /** Constructor. */
    public JaxoConsoleHandler() {
        super();
        setLevel(Level.INFO);
        setFormatter(new LogFormatter());
    }
}
