/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.io.imports;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import net.sf.jaxodraw.plugin.JaxoImportPlugin;
import net.sf.jaxodraw.util.JaxoInfo;


/**
 * An abstract superclass for all built-in importing classes.
 *
 * @since 2.0
 */
public abstract class JaxoImport extends JaxoImportPlugin {
    private static List<JaxoImportPlugin> importFormats;

    /**
     * Protected empty constructor.
     */
    protected JaxoImport() {
        // protected to avoid public default constructor
        super();
    }

    /**
     * {@inheritDoc}
     *
     * @return As a built-in format, this always returns true.
     */
    public boolean makeAvailableAtRuntime() {
        return true;
    }

    /**
     * {@inheritDoc}
     */
    public String version() {
        return JaxoInfo.VERSION_NUMBER;
    }

    /**
     * Returns a list of import formats that are available within
     * the core of JaxoDraw by default. Elements are either
     * Lists (containing a subgroup of JaxoImport formats), or JaxoImports.
     *
     * @return The list of built-in export formats.
     */
    public static List<JaxoImportPlugin> getBuiltInFormats() {
        synchronized (JaxoImport.class) {
            if (importFormats == null) {
                importFormats = new ArrayList<JaxoImportPlugin>(2);
                importFormats.add(new JaxoImportAxodraw());
                importFormats = Collections.unmodifiableList(importFormats);
            }

            return importFormats;
        }
    }
}
