/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */

package net.sf.jaxodraw.gui.swing;

import java.util.EventObject;


/**
 * An EventObject for a closing tab.
 */
public class TabClosingEvent extends EventObject {
    private static final long serialVersionUID = 2L;
    private final int index;

    /**
     * A closing event.
     * @param source The source.
     * @param ind The index of the tab.
     */
    public TabClosingEvent(final JaxoClosableTabbedPane source, final int ind) {
        super(source);

        this.index = ind;
    }

    /**
     * Index that was requested to be closed.
     * @return The index of the tab.
     */
    public final int getIndex() {
        return index;
    }
}
