/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;

import javax.swing.border.TitledBorder;


/** Subclass of TitledBorder that has more uniform insets.
 * @since 2.0
 */
public class JaxoTitledBorder extends TitledBorder {
    private static final long serialVersionUID = 7526471155622776147L;

    /** Create with given text.
     * @param text the border text.
     */
    public JaxoTitledBorder(final String text) {
        super(text);
    }

    /** {@inheritDoc} */
    @Override
    public Insets getBorderInsets(final Component c) {
        return getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    /** {@inheritDoc} */
    @Override
    public Insets getBorderInsets(final Component c, final Insets insets) {
        super.getBorderInsets(c, insets);
        final Insets o = getBorder().getBorderInsets(c);

        insets.bottom = insets.top + (o.bottom - o.top);
        insets.left = insets.top + (o.left - o.top);
        insets.right = insets.top + (o.right - o.top);

        return insets;
    }

    /** {@inheritDoc} */
    @Override
    public void paintBorder(final Component c, final Graphics g, final int x, final int y, final int width,
        final int height) {
        final Insets n = super.getBorderInsets(c);
        final Insets o = getBorder().getBorderInsets(c);

        super.paintBorder(c, g, (x + ((n.left - o.left) / 2)) - 2, y,
            width - (((n.left + n.right) - o.left - o.right) / 2) + 4,
            height - ((n.bottom - o.bottom) / 2) + 2);
    }
}
