/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import javax.swing.JCheckBox;
import javax.swing.border.TitledBorder;

import net.sf.jaxodraw.util.JaxoLanguage;


/** A panel to change the symmetry property of an object.
 * @since 2.0
 */
public class JaxoSymmEditPanel extends JaxoEditPanel {
    private static final long serialVersionUID = 7526471155622776147L;
    private transient JCheckBox symmcb;

    /** Constructor: a symmetry edit panel with default value false. */
    public JaxoSymmEditPanel() {
        this(false);
    }

    /** Constructor: a symmetry edit panel with the given params.
     * @param symm Whether the object is symmetric.
     */
    public JaxoSymmEditPanel(final boolean symm) {
        super();
        symmcb =
            new JCheckBox(JaxoLanguage.translate("JaxoSymmEditPanel.symmetric"));
        symmcb.setSelected(symm);
        symmcb.setName("symm");

        this.setLayout(getOneColumnPanelLayout());

        final TitledBorder lineSymmTitle =
            createI18NBorder("JaxoSymmEditPanel.title");
        this.setPreferredSize(getCheckBoxPanelSize());
        this.setBorder(lineSymmTitle);
        this.add(symmcb);
    }

    /** {@inheritDoc} */
    public void addEditPanelListener(final JaxoEditPanelListener listener) {
        if (listener != null) {
            symmcb.addItemListener(listener);
        }
    }
}
