/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import javax.swing.JCheckBox;
import javax.swing.border.TitledBorder;

import net.sf.jaxodraw.util.JaxoLanguage;


/** A panel to change the stretching property of an object.
 * @since 2.0
 */
public class JaxoStretchingEditPanel extends JaxoEditPanel {
    private static final long serialVersionUID = 7526471155622776147L;
    private transient JCheckBox stretchcb;

    /** Constructor: a stretching edit panel with default value false. */
    public JaxoStretchingEditPanel() {
        this(false);
    }

    /** Constructor: a stretching edit panel with the given params.
     * @param stretch Whether the object is stretched.
     */
    public JaxoStretchingEditPanel(final boolean stretch) {
        super();
        stretchcb =
            new JCheckBox(JaxoLanguage.translate(
                    "JaxoStretchingEditPanel.redShift"));
        stretchcb.setSelected(stretch);
        stretchcb.setName("stretch");

        this.setLayout(getOneColumnPanelLayout());

        final TitledBorder lineSymmTitle =
            createI18NBorder("JaxoStretchingEditPanel.title");
        this.setPreferredSize(getCheckBoxPanelSize());
        this.setBorder(lineSymmTitle);
        this.add(stretchcb);
    }

    /** {@inheritDoc} */
    public void addEditPanelListener(final JaxoEditPanelListener listener) {
        if (listener != null) {
            stretchcb.addItemListener(listener);
        }
    }
}
