/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import javax.swing.JSpinner;

import net.sf.jaxodraw.gui.swing.spinner.JaxoSpinnerComboBox;
import net.sf.jaxodraw.gui.swing.spinner.JaxoSpinnerRotationModel;

/** A panel to change the rotation of an object.
 * @since 2.0
 */
public class JaxoRotationEditPanel extends JaxoEditPanel {
    private static final long serialVersionUID = 7526471155622776147L;
    private transient JSpinner sprotin;

    /** Constructor: returns a rotation edit panel with default rotation 0. */
    public JaxoRotationEditPanel() {
        this(0);
    }

    /** Constructor: returns a rotation edit panel with the given rotation.
     * @param oldAngle The rotation angle of the object to edited by this panel.
     */
    public JaxoRotationEditPanel(final int oldAngle) {
        super();
        this.setLayout(getPanelLayout());

        final JaxoSpinnerRotationModel r = new JaxoSpinnerRotationModel(oldAngle);

        this.sprotin = r.newSpinner();
        this.sprotin.setName("rotation");
        this.setBorder(createI18NBorder("JaxoRotationEditPanel.title"));
        this.add(createI18NLabel("JaxoRotationEditPanel.angle"));
        this.add(new JaxoSpinnerComboBox(sprotin,
                JaxoOptionsPanel.getRotationAngleDefaults()));
    }

    /** {@inheritDoc} */
    public void addEditPanelListener(final JaxoEditPanelListener listener) {
        if (listener != null) {
            sprotin.addChangeListener(listener);
        }
    }
}
