/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;

import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

import net.sf.jaxodraw.gui.swing.spinner.JaxoFixedJSpinner;


/** A panel to change the x,y parameters of an object.
 * @since 2.0
 */
public class JaxoPositionEditPanel extends JaxoEditPanel {
    private static final long serialVersionUID = 7526471155622776147L;
    private transient JSpinner spx;
    private transient JSpinner spy;

    /** Constructor: returns a Position edit panel with
     * default value 100 for all variables.
     */
    public JaxoPositionEditPanel() {
        this(100, 100);
    }

    /** Constructor: returns a Position edit panel with
     * given values for the variables.
     * @param xin Default value for the xin sub-panel.
     * @param yin Default value for the yin sub-panel.
     */
    public JaxoPositionEditPanel(final int xin, final int yin) {
        super();
        final Dimension size = new Dimension(120, 20);
        final GridLayout layout = new GridLayout(0, 2);

        final JPanel pxin = new JPanel();
        pxin.setLayout(layout);

        final SpinnerNumberModel modelXin = new SpinnerNumberModel();
        modelXin.setValue(Integer.valueOf(xin));
        pxin.add(createLabel("X: "));

        this.spx = new JaxoFixedJSpinner(modelXin);
        spx.setName("spxin");
        pxin.add(spx);

        final JPanel pyin = new JPanel();
        pyin.setLayout(layout);

        final SpinnerNumberModel modelYin = new SpinnerNumberModel();
        modelYin.setValue(Integer.valueOf(yin));
        pyin.add(createLabel("Y: "));

        this.spy = new JaxoFixedJSpinner(modelYin);
        spy.setName("spyin");
        pyin.add(spy);

        final JPanel dimSPanel = new JPanel();
        final GridBagLayout gb = new GridBagLayout();
        final GridBagConstraints sc = new GridBagConstraints();
        dimSPanel.setLayout(gb);

        sc.gridx = 0;
        sc.gridy = 0;
        sc.insets = new Insets(0, 0, 5, 0);
        pxin.setPreferredSize(size);
        dimSPanel.add(pxin, sc);

        sc.gridx = 1;
        sc.gridy = 0;
        sc.insets = new Insets(0, 0, 5, 5);
        pyin.setPreferredSize(size);
        dimSPanel.add(pyin, sc);

        setLineBoxLayout();

        final TitledBorder dimSTitle =
            createI18NBorder("JaxoPositionEditPanel.title");
        this.setBorder(dimSTitle);
        this.add(dimSPanel);

    }

    /** {@inheritDoc} */
    public void addEditPanelListener(final JaxoEditPanelListener listener) {
        if (listener != null) {
            spx.addChangeListener(listener);
            spy.addChangeListener(listener);
        }
    }
}
