/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import javax.swing.JComboBox;
import javax.swing.border.TitledBorder;


/** A panel to change the rotation of an object.
 * @since 2.0
 */
public class JaxoLatexFontSizePanel extends JaxoEditPanel {
    private static final long serialVersionUID = 7526471155622776147L;
    private static final String[] SIZES =
    {
        "tiny", "scriptsize", "footnotesize", "small", "normalsize", "large",
        "Large", "LARGE", "huge", "Huge"
    };

    // private fields
    private transient JComboBox fscomb;

    /** Constructor: returns a latex font size edit panel for a latex text. */
    public JaxoLatexFontSizePanel() {
        this(4);
    }

    /** Constructor: returns a latex font size edit panel for a latex text.
     * @param size A LaTeX text size.
     */
    public JaxoLatexFontSizePanel(final int size) {
        super();
        fscomb = new JComboBox(SIZES);
        fscomb.setName("latexfontsize");
        fscomb.setSelectedIndex(size);
        this.setLayout(getPanelLayout());
        final TitledBorder fsPanelTitle =
            createI18NBorder("JaxoLatexFontSizePanel.title");
        this.setBorder(fsPanelTitle);
        this.add(fscomb);
    }

    /** {@inheritDoc} */
    public void addEditPanelListener(final JaxoEditPanelListener listener) {
        if (listener != null) {
            fscomb.addItemListener(listener);
        }
    }
}
