/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import javax.swing.JComboBox;

import net.sf.jaxodraw.util.JaxoLanguage;


/** A panel to change the rotation of an object.
 * @since 2.0
 */
public class JaxoLatexAlignPanel extends JaxoEditPanel {
    private static final long serialVersionUID = 7526471155622776147L;
    private static final String[] ALIGNMENTS =
    {
        JaxoLanguage.translate("Left-Top"),
        JaxoLanguage.translate("Left-Center"),
        JaxoLanguage.translate("Left-Bottom"),
        JaxoLanguage.translate("Center-Top"),
        JaxoLanguage.translate("Center-Center"),
        JaxoLanguage.translate("Center-Bottom"),
        JaxoLanguage.translate("Right-Top"),
        JaxoLanguage.translate("Right-Center"),
        JaxoLanguage.translate("Right-Bottom")
    };

    // private fields
    private transient JComboBox allicomb;

    /** Constructor: returns a latex align edit panel for a latex text. */
    public JaxoLatexAlignPanel() {
        this(4);
    }

    /**
     * Constructor: returns a latex align edit panel for a latex text.
     *
     * @param align a valid latex alignment.
     */
    public JaxoLatexAlignPanel(final int align) {
        super();
        allicomb = new JComboBox(ALIGNMENTS);
        allicomb.setName("latexalign");
        allicomb.setSelectedIndex(align);
        this.setLayout(getPanelLayout());
        this.setBorder(createI18NBorder("JaxoLatexAlignPanel.title"));
        this.add(allicomb);
    }

    /** {@inheritDoc} */
    public void addEditPanelListener(final JaxoEditPanelListener listener) {
        if (listener != null) {
            allicomb.addItemListener(listener);
        }
    }
}
