/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;

import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

import net.sf.jaxodraw.gui.swing.spinner.JaxoFixedJSpinner;

/** A panel to change the x,y, width and height parameters of an object.
 * @since 2.0
 */
public class JaxoCenterSizeEditPanel extends JaxoEditPanel {
    private static final long serialVersionUID = 7526471155622776147L;
    private transient JSpinner spxin;
    private transient JSpinner spyin;
    private transient JSpinner spwidth;
    private transient JSpinner spheight;

    /** Constructor: returns a center/size edit panel with
     * default values for all variables.
     */
    public JaxoCenterSizeEditPanel() {
        this(200, 200, 20, 20);
    }

    /** Constructor: returns a center/size edit panel with
     * given values for the variables.
     * @param x Default value for the x sub-panel.
     * @param y Default value for the y sub-panel.
     * @param w Default value for the width sub-panel.
     * @param h Default value for the height sub-panel.
     */
    public JaxoCenterSizeEditPanel(final int x, final int y, final int w, final int h) {
        super();
        final Dimension size = new Dimension(120, 20);
        final GridLayout layout = new GridLayout(0, 2);

        final JPanel pxin = new JPanel();
        pxin.setLayout(layout);

        final SpinnerNumberModel modelXin = new SpinnerNumberModel();
        modelXin.setValue(Integer.valueOf(x));
        pxin.add(createLabel("X: "));

        this.spxin = new JaxoFixedJSpinner(modelXin);
        spxin.setName("spxin");
        pxin.add(spxin);

        final JPanel pyin = new JPanel();
        pyin.setLayout(layout);

        final SpinnerNumberModel modelYin = new SpinnerNumberModel();
        modelYin.setValue(Integer.valueOf(y));
        pyin.add(createLabel("Y: "));

        this.spyin = new JaxoFixedJSpinner(modelYin);
        spyin.setName("spyin");
        pyin.add(spyin);

        final JPanel pwidth = new JPanel();
        pwidth.setLayout(layout);

        final SpinnerNumberModel modelwidth = new SpinnerNumberModel();
        modelwidth.setValue(Integer.valueOf(w));
        pwidth.add(createI18NLabel("JaxoCenterSizeEditPanel.width"));

        this.spwidth = new JaxoFixedJSpinner(modelwidth);
        spwidth.setName("spwidth");
        pwidth.add(spwidth);

        final JPanel pheight = new JPanel();
        pheight.setLayout(layout);

        final SpinnerNumberModel modelheight = new SpinnerNumberModel();
        modelheight.setValue(Integer.valueOf(h));
        pheight.add(createI18NLabel("JaxoCenterSizeEditPanel.height"));

        this.spheight = new JaxoFixedJSpinner(modelheight);
        spheight.setName("spheight");
        pheight.add(spheight);

        final JPanel dimSPanel = new JPanel();
        final GridBagLayout gb = new GridBagLayout();
        final GridBagConstraints sc = new GridBagConstraints();
        dimSPanel.setLayout(gb);

        sc.gridx = 0;
        sc.gridy = 0;
        sc.insets = new Insets(0, 0, 0, 5);
        pxin.setPreferredSize(size);
        dimSPanel.add(pxin, sc);

        sc.gridx = 0;
        sc.gridy = 1;
        sc.insets = new Insets(5, 0, 5, 5);
        pyin.setPreferredSize(size);
        dimSPanel.add(pyin, sc);

        sc.gridx = 1;
        sc.gridy = 0;
        sc.insets = new Insets(0, 5, 0, 5);
        pwidth.setPreferredSize(size);
        dimSPanel.add(pwidth, sc);

        sc.gridx = 1;
        sc.gridy = 1;
        sc.insets = new Insets(5, 5, 5, 5);
        pheight.setPreferredSize(size);
        dimSPanel.add(pheight, sc);

        setLineBoxLayout();

        final TitledBorder dimSTitle =
            createI18NBorder("JaxoCenterSizeEditPanel.title");
        this.setBorder(dimSTitle);
        this.add(dimSPanel);
    }

    /** {@inheritDoc} */
    public void addEditPanelListener(final JaxoEditPanelListener listener) {
        if (listener != null) {
            spxin.addChangeListener(listener);
            spyin.addChangeListener(listener);
            spwidth.addChangeListener(listener);
            spheight.addChangeListener(listener);
        }
    }
}
