/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;

import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

import net.sf.jaxodraw.gui.swing.spinner.JaxoFixedJSpinner;


/** A panel to change the x,y and radius parameters of an object.
 * @since 2.0
 */
public class Jaxo2PointsEditPanel extends JaxoEditPanel {
    private static final long serialVersionUID = 7526471155622776147L;
    private transient JSpinner spxin;
    private transient JSpinner spyin;
    private transient JSpinner spxfin;
    private transient JSpinner spyfin;

    /** Constructor: returns a 2Points edit panel with
     * default value 0 for all variables.
     */
    public Jaxo2PointsEditPanel() {
        this(new Point[] {new Point(), new Point()});
    }

    /**
     * Constructor: returns a 2Points edit panel.
     *
     * @param points The initial points of the sub-panel.
     */
    public Jaxo2PointsEditPanel(final Point[] points) {
        super();
        final Dimension size = new Dimension(120, 20);
        final GridLayout layout = new GridLayout(0, 2);

        final JPanel pxin = new JPanel();
        pxin.setLayout(layout);

        final SpinnerNumberModel modelXin = new SpinnerNumberModel();
        modelXin.setValue(Integer.valueOf(points[0].x));
        pxin.add(createLabel("Xin: "));

        this.spxin = new JaxoFixedJSpinner(modelXin);
        spxin.setName("spx");
        pxin.add(spxin);

        final JPanel pyin = new JPanel();
        pyin.setLayout(layout);

        final SpinnerNumberModel modelYin = new SpinnerNumberModel();
        modelYin.setValue(Integer.valueOf(points[0].y));
        pyin.add(createLabel("Yin: "));

        this.spyin = new JaxoFixedJSpinner(modelYin);
        spyin.setName("spy");
        pyin.add(spyin);

        final JPanel pxfin = new JPanel();
        pxfin.setLayout(layout);

        final SpinnerNumberModel modelXfin = new SpinnerNumberModel();
        modelXfin.setValue(Integer.valueOf(points[1].x));
        pxfin.add(createLabel("Xfin: "));

        this.spxfin = new JaxoFixedJSpinner(modelXfin);
        spxfin.setName("spxfin");
        pxfin.add(spxfin);

        final JPanel pyfin = new JPanel();
        pyfin.setLayout(layout);

        final SpinnerNumberModel modelYfin = new SpinnerNumberModel();
        modelYfin.setValue(Integer.valueOf(points[1].y));
        pyfin.add(createLabel("Yfin: "));

        this.spyfin = new JaxoFixedJSpinner(modelYfin);
        spyfin.setName("spyfin");
        pyfin.add(spyfin);

        final JPanel dimSPanel = new JPanel();
        final GridBagLayout gb = new GridBagLayout();
        final GridBagConstraints sc = new GridBagConstraints();
        dimSPanel.setLayout(gb);

        sc.gridx = 0;
        sc.gridy = 0;
        pxin.setPreferredSize(size);
        dimSPanel.add(pxin, sc);

        sc.gridx = 0;
        sc.gridy = 1;
        sc.insets = new Insets(5, 0, 5, 0);
        pyin.setPreferredSize(size);
        dimSPanel.add(pyin, sc);

        sc.gridx = 1;
        sc.gridy = 0;
        sc.insets = new Insets(0, 0, 0, 5);
        pxfin.setPreferredSize(size);
        dimSPanel.add(pxfin, sc);

        sc.gridx = 1;
        sc.gridy = 1;
        sc.insets = new Insets(5, 0, 5, 5);
        pyfin.setPreferredSize(size);
        dimSPanel.add(pyfin, sc);

        setLineBoxLayout();

        final TitledBorder dimSTitle =
            createI18NBorder("Jaxo2PointsEditPanel.title");
        this.setBorder(dimSTitle);
        this.add(dimSPanel);
    }

    /** {@inheritDoc} */
    public void addEditPanelListener(final JaxoEditPanelListener listener) {
        if (listener != null) {
            spxin.addChangeListener(listener);
            spxfin.addChangeListener(listener);
            spyin.addChangeListener(listener);
            spyfin.addChangeListener(listener);
        }
    }
}
