/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */

package net.sf.jaxodraw.gui.panel;


import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;

import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

/** The progress dialog for building the user guide. */
public class JaxoProgressDialog extends JFrame {
    private static final long serialVersionUID = 1L;

    private final JProgressBar progressBar;
    private final JPanel contentPane = new JPanel();

    /**
     * Constructor.
     *
     * @param parent the parent component of this dialog.
     *      May be null, in which case the dialog is centered on the screen.
     * @param min the minimum value of the progress bar.
     * @param max the maximum value of the progress bar.
     * @param title the title of the dialog.
     */
    public JaxoProgressDialog(final Component parent, final int min, final int max, final String title) {
        super();
        setUndecorated(true);
        setLocationRelativeTo(parent);

        this.progressBar = new JProgressBar(min, max);

        final JLabel label = new JLabel(title);

        contentPane.setLayout(new BorderLayout());
        contentPane.add(label, BorderLayout.NORTH);
        contentPane.add(progressBar, BorderLayout.SOUTH);
        contentPane.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));

        this.setContentPane(contentPane);
    }

    /**
     * Sets a new value for the progress bar.
     *
     * @param value the new value to set.
     */
    public void setValue(final int value) {
        progressBar.setValue(value);

        final Rectangle rect = this.getBounds();
        rect.x = 0;
        rect.y = 0;
        contentPane.paintImmediately(rect);
    }
}
