/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.menu;

import java.beans.PropertyChangeEvent;

import javax.swing.ButtonGroup;
import javax.swing.JRadioButtonMenuItem;

import net.sf.jaxodraw.util.JaxoConstants;
import net.sf.jaxodraw.util.JaxoLanguage;

/**
 * A JaxoMenu for language MenuItems.
 */
public class LanguageMenu extends JaxoMenu {
    private static final long serialVersionUID = 7526471155622776147L;
    private final JRadioButtonMenuItem englishBT;
    private final JRadioButtonMenuItem germanBT;
    private final JRadioButtonMenuItem frenchBT;
    private final JRadioButtonMenuItem spanishBT;
    private final JRadioButtonMenuItem italianBT;

    /**
     * Creates a new instance of LanguageMenu.
     *
     * @param initLang one of the language strings defined in JaxoLanguage.
     */
    public LanguageMenu(final String initLang) {
        super();
        final ButtonGroup languageGroup = new ButtonGroup();

        englishBT = new JRadioButtonMenuItem();
        JaxoMenuUtils.setActionCommand(englishBT, JaxoConstants.ENGLISH);
        JaxoMenuUtils.setAccelerator(englishBT, 'e');
        JaxoMenuUtils.setLanguageKey(englishBT, "JaxoLanguage.english");
        languageGroup.add(englishBT);

        germanBT = new JRadioButtonMenuItem();
        JaxoMenuUtils.setActionCommand(germanBT, JaxoConstants.GERMAN);
        JaxoMenuUtils.setAccelerator(germanBT, 'g');
        JaxoMenuUtils.setLanguageKey(germanBT, "JaxoLanguage.german");
        languageGroup.add(germanBT);

        frenchBT = new JRadioButtonMenuItem();
        JaxoMenuUtils.setActionCommand(frenchBT, JaxoConstants.FRENCH);
        JaxoMenuUtils.setAccelerator(frenchBT, 'f');
        JaxoMenuUtils.setLanguageKey(frenchBT, "JaxoLanguage.french");
        languageGroup.add(frenchBT);

        spanishBT = new JRadioButtonMenuItem();
        JaxoMenuUtils.setActionCommand(spanishBT, JaxoConstants.SPANISH);
        JaxoMenuUtils.setAccelerator(spanishBT, 's');
        JaxoMenuUtils.setLanguageKey(spanishBT, "JaxoLanguage.spanish");
        languageGroup.add(spanishBT);

        italianBT = new JRadioButtonMenuItem();
        JaxoMenuUtils.setActionCommand(italianBT, JaxoConstants.ITALIAN);
        JaxoMenuUtils.setAccelerator(italianBT, 'i');
        JaxoMenuUtils.setLanguageKey(italianBT, "JaxoLanguage.italian");
        languageGroup.add(italianBT);

        this.add(englishBT);
        this.add(germanBT);
        this.add(frenchBT);
        this.add(spanishBT);
        this.add(italianBT);

        JaxoMenuUtils.setLanguageKey(this, "JaxoOptionsMenu.language");
        setLanguageButton(initLang);
    }

    /**
     * Applies a property change event.
     *
     * @param e the change event.
     */
    public void propertyChange(final PropertyChangeEvent e) {
        final String name = e.getPropertyName();
        if ("Jaxo.language".equals(name)) {
            setLanguageButton((String) e.getNewValue());
        }
    }

    /**
     * Notification on language changes: select the corresponding button.
     *
     * @param value one of the language strings defined in JaxoLanguage.
     */
    private void setLanguageButton(final String value) {
        if (value.equals(JaxoLanguage.ENGLISH)) {
            englishBT.setSelected(true);
        } else if (value.equals(JaxoLanguage.GERMAN)) {
            germanBT.setSelected(true);
        } else if (value.equals(JaxoLanguage.FRENCH)) {
            frenchBT.setSelected(true);
        } else if (value.equals(JaxoLanguage.SPANISH)) {
            spanishBT.setSelected(true);
        } else if (value.equals(JaxoLanguage.ITALIAN)) {
            italianBT.setSelected(true);
        }
    }

}
