/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.menu;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.beans.PropertyChangeListener;

import javax.swing.JMenu;
import javax.swing.JMenuItem;

import net.sf.jaxodraw.util.JaxoLocalized;

/**
 * Base class for JaxoDraw menus.
 */
public abstract class JaxoMenu extends JMenu implements JaxoLocalized,
        PropertyChangeListener {

    /** The Shift key modifier constant. */
    public static final int SHIFT_MASK = ActionEvent.SHIFT_MASK;

    /** The Control key modifier constant. */
    public static final int CTRL_MASK = ActionEvent.CTRL_MASK;

    /** The Meta key modifier constant. */
    public static final int META_MASK = ActionEvent.META_MASK;

    /** The Alt key modifier constant. */
    public static final int ALT_MASK = ActionEvent.ALT_MASK;

    /** The default key modifier constant. */
    public static final int DEFAULT_MASK =
        Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    /**
     * Adds an ActionListener to this menu and all its items.
     *
     * @param l the ActionListener to add.
     */
    @Override
    public void addActionListener(final ActionListener l) {
        super.addActionListener(l);

        for (int i = 0; i < getItemCount(); i++) {
            if (getItem(i) != null) {
                getItem(i).addActionListener(l);
            }
        }
    }

    /** {@inheritDoc} */
    public void updateLanguage() {
        JaxoMenuUtils.updateLanguage(this);

        for (int i = 0; i < getItemCount(); i++) {
            final JMenuItem item = getItem(i);
            if (item != null) {
                if (item instanceof JaxoMenu) {
                    ((JaxoMenu) item).updateLanguage();
                } else {
                    JaxoMenuUtils.updateLanguage(item);
                }
            }
        }
    }

}
