/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.menu;

import java.beans.PropertyChangeEvent;

import java.util.Locale;

import javax.swing.JMenuItem;

import net.sf.jaxodraw.util.JaxoConstants;
import net.sf.jaxodraw.util.JaxoInfo;

/** The help menu items.
 * @since 2.0
 */
public class JaxoHelpMenu extends JaxoMenu {
    private static final long serialVersionUID = 7526471155622776147L;

    /** Creates the help menu from the specified JaxoMainPanel. */
    public JaxoHelpMenu() {
        super();

        this.add(aboutMenuItem());
        this.add(sysInfoMenuItem());

        addSeparator();

        this.add(usrGuideMenuItem());
        this.add(macReadmeMenuItem());

        JaxoMenuUtils.setLanguageKey(this, "Help");
        updateLanguage();
    }

    /**
     * Applies a property change event.
     *
     * @param e the change event.
     */
    public void propertyChange(final PropertyChangeEvent e) {
        // nothing to do
    }

      //
     // private methods
    //

    private JMenuItem macReadmeMenuItem() {
        final JMenuItem macReadmeMI = new JMenuItem();
        JaxoMenuUtils.setAccelerator(macReadmeMI, 'M');
        JaxoMenuUtils.setActionCommand(macReadmeMI, JaxoConstants.MAC_README);
        JaxoMenuUtils.setLanguageKey(macReadmeMI, "Mac_Readme");
        macReadmeMI.setVisible(
                JaxoInfo.OS_NAME.toLowerCase(Locale.ENGLISH).startsWith("mac os x"));
        return macReadmeMI;
    }

    private JMenuItem usrGuideMenuItem() {
        final JMenuItem usrGuideMI = new JMenuItem();
        JaxoMenuUtils.setAccelerator(usrGuideMI, 'G');
        JaxoMenuUtils.setActionCommand(usrGuideMI, JaxoConstants.USR_GUIDE);
        JaxoMenuUtils.setLanguageKey(usrGuideMI, "User_guide");
        return usrGuideMI;
    }

    private JMenuItem sysInfoMenuItem() {
        final JMenuItem sysInfoMI = new JMenuItem();
        JaxoMenuUtils.setAccelerator(sysInfoMI, 'I');
        JaxoMenuUtils.setActionCommand(sysInfoMI, JaxoConstants.SYS_INFO);
        JaxoMenuUtils.setLanguageKey(sysInfoMI, "System_Info");
        return sysInfoMI;
    }

    private JMenuItem aboutMenuItem() {
        final JMenuItem aboutMI = new JMenuItem();
        JaxoMenuUtils.setAccelerator(aboutMI, '?');
        JaxoMenuUtils.setActionCommand(aboutMI, JaxoConstants.ABOUT);
        JaxoMenuUtils.setLanguageKey(aboutMI, "About");
        return aboutMI;
    }
}
