/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.handle;

import java.awt.Color;

import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;


/** A default implementation for handles.
 * @since 2.0
 */
public class JaxoDefaultHandle extends AbstractJaxoHandle {
    /** {@inheritDoc}
     * This implementation paints the default squares.
     */
    public void paint(final JaxoGraphics2D g2, final int x, final int y, final boolean marked,
        final Color handleColor) {
        final int handleSize = getSize();
        final int h2 = handleSize / 2;
        if (marked) {
            g2.setColor(getFillColor());
            g2.fillRect(x - h2, y - h2, handleSize, handleSize);
        }

        g2.setColor(handleColor);
        g2.setStroke(getStroke());
        g2.drawRect(x - h2, y - h2, handleSize, handleSize);
    }

    /** {@inheritDoc}
     * This implementation checks if the point is contained within
     * a square of length getSize() around the handle point.
     */
    public boolean contains(final int handleX, final int handleY, final int x, final int y) {
        final int l2 = getSize() / 2;
        return (x <= (handleX + l2)) && (x >= (handleX - l2))
        && (y <= (handleY + l2)) && (y >= (handleY - l2));
    }
}
