/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.grid;

import java.awt.Point;


/**
 * Grid: A grid "is" a collection of Points in the plane.
 * An arbitrary point can be mapped to its closest point on the grid.
 * This interface only knows about points on the grid, not about painting.
 * In general, the grid is assumed to be infinite in all directions, not restricted
 * to current bounding boxes or canvas size (of course, a specific grid could, e.g.,
 * claim that there are no grid points with negative coordinates).
 *
 * @since 2.0
 */
public interface JaxoGrid {
    /**
     * Determines if 'p' is on the grid.
     * This is equivalent to <code>p.equals(snappedPoint(p))</code>.
     *
     * @param p The point to snap.
     * @return True if p is on the grid.
     */
    boolean isSnapped(Point p);

    /**
     * Closest point to 'p' on the grid.
     *
     * @param p The point to snap.
     * @return The closest grid point.
     */
    Point snappedPoint(Point p);

    /**
     * Change 'p' to the closest point on the grid.
     *
     * @param p The point to snap.
     */
    void snapPoint(Point p);
}
