/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.Window;
import io.flutter.plugin.common.ActivityLifecycleListener;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PlatformPlugin
implements MethodChannel.MethodCallHandler,
ActivityLifecycleListener {
    private final Activity mActivity;
    private JSONObject mCurrentTheme;
    public static final int DEFAULT_SYSTEM_UI = 1280;
    private static final String kTextPlainFormat = "text/plain";
    private int mEnabledOverlays;

    public PlatformPlugin(Activity activity) {
        this.mActivity = activity;
        this.mEnabledOverlays = 1280;
    }

    @Override
    public void onMethodCall(MethodCall call, MethodChannel.Result result) {
        String method = call.method;
        Object arguments = call.arguments;
        try {
            if (method.equals("SystemSound.play")) {
                this.playSystemSound((String)arguments);
                result.success(null);
            } else if (method.equals("HapticFeedback.vibrate")) {
                this.vibrateHapticFeedback((String)arguments);
                result.success(null);
            } else if (method.equals("SystemChrome.setPreferredOrientations")) {
                this.setSystemChromePreferredOrientations((JSONArray)arguments);
                result.success(null);
            } else if (method.equals("SystemChrome.setApplicationSwitcherDescription")) {
                this.setSystemChromeApplicationSwitcherDescription((JSONObject)arguments);
                result.success(null);
            } else if (method.equals("SystemChrome.setEnabledSystemUIOverlays")) {
                this.setSystemChromeEnabledSystemUIOverlays((JSONArray)arguments);
                result.success(null);
            } else if (method.equals("SystemChrome.restoreSystemUIOverlays")) {
                this.restoreSystemChromeSystemUIOverlays();
                result.success(null);
            } else if (method.equals("SystemChrome.setSystemUIOverlayStyle")) {
                this.setSystemChromeSystemUIOverlayStyle((JSONObject)arguments);
                result.success(null);
            } else if (method.equals("SystemNavigator.pop")) {
                this.popSystemNavigator();
                result.success(null);
            } else if (method.equals("Clipboard.getData")) {
                result.success(this.getClipboardData((String)arguments));
            } else if (method.equals("Clipboard.setData")) {
                this.setClipboardData((JSONObject)arguments);
                result.success(null);
            } else {
                result.notImplemented();
            }
        }
        catch (JSONException e) {
            result.error("error", "JSON error: " + e.getMessage(), null);
        }
    }

    private void playSystemSound(String soundType) {
        if (soundType.equals("SystemSoundType.click")) {
            View view = this.mActivity.getWindow().getDecorView();
            view.playSoundEffect(0);
        }
    }

    private void vibrateHapticFeedback(String feedbackType) {
        View view = this.mActivity.getWindow().getDecorView();
        if (feedbackType == null) {
            view.performHapticFeedback(0);
        } else if (feedbackType.equals("HapticFeedbackType.lightImpact")) {
            view.performHapticFeedback(1);
        } else if (feedbackType.equals("HapticFeedbackType.mediumImpact")) {
            view.performHapticFeedback(3);
        } else if (feedbackType.equals("HapticFeedbackType.heavyImpact")) {
            view.performHapticFeedback(6);
        } else if (feedbackType.equals("HapticFeedbackType.selectionClick")) {
            view.performHapticFeedback(4);
        }
    }

    private void setSystemChromePreferredOrientations(JSONArray orientations) throws JSONException {
        int requestedOrientation = 0;
        int firstRequestedOrientation = 0;
        for (int index = 0; index < orientations.length(); ++index) {
            if (orientations.getString(index).equals("DeviceOrientation.portraitUp")) {
                requestedOrientation |= 1;
            } else if (orientations.getString(index).equals("DeviceOrientation.landscapeLeft")) {
                requestedOrientation |= 2;
            } else if (orientations.getString(index).equals("DeviceOrientation.portraitDown")) {
                requestedOrientation |= 4;
            } else if (orientations.getString(index).equals("DeviceOrientation.landscapeRight")) {
                requestedOrientation |= 8;
            }
            if (firstRequestedOrientation != 0) continue;
            firstRequestedOrientation = requestedOrientation;
        }
        block0 : switch (requestedOrientation) {
            case 0: {
                this.mActivity.setRequestedOrientation(-1);
                break;
            }
            case 1: {
                this.mActivity.setRequestedOrientation(1);
                break;
            }
            case 2: {
                this.mActivity.setRequestedOrientation(0);
                break;
            }
            case 4: {
                this.mActivity.setRequestedOrientation(9);
                break;
            }
            case 5: {
                this.mActivity.setRequestedOrientation(12);
                break;
            }
            case 8: {
                this.mActivity.setRequestedOrientation(8);
                break;
            }
            case 10: {
                this.mActivity.setRequestedOrientation(11);
                break;
            }
            case 11: {
                this.mActivity.setRequestedOrientation(2);
                break;
            }
            case 15: {
                this.mActivity.setRequestedOrientation(13);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                switch (firstRequestedOrientation) {
                    case 1: {
                        this.mActivity.setRequestedOrientation(1);
                        break block0;
                    }
                    case 2: {
                        this.mActivity.setRequestedOrientation(0);
                        break block0;
                    }
                    case 4: {
                        this.mActivity.setRequestedOrientation(9);
                        break block0;
                    }
                    case 8: {
                        this.mActivity.setRequestedOrientation(8);
                    }
                }
            }
        }
    }

    private void setSystemChromeApplicationSwitcherDescription(JSONObject description) throws JSONException {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        int color = description.getInt("primaryColor");
        if (color != 0) {
            color |= 0xFF000000;
        }
        this.mActivity.setTaskDescription(new ActivityManager.TaskDescription(description.getString("label"), null, color));
    }

    private void setSystemChromeEnabledSystemUIOverlays(JSONArray overlays) throws JSONException {
        int enabledOverlays = 1798;
        if (overlays.length() == 0) {
            enabledOverlays |= 0x1000;
        }
        for (int i = 0; i < overlays.length(); ++i) {
            String overlay = overlays.getString(i);
            if (overlay.equals("SystemUiOverlay.top")) {
                enabledOverlays &= 0xFFFFFFFB;
                continue;
            }
            if (!overlay.equals("SystemUiOverlay.bottom")) continue;
            enabledOverlays &= 0xFFFFFDFF;
            enabledOverlays &= 0xFFFFFFFD;
        }
        this.mEnabledOverlays = enabledOverlays;
        this.updateSystemUiOverlays();
    }

    private void updateSystemUiOverlays() {
        this.mActivity.getWindow().getDecorView().setSystemUiVisibility(this.mEnabledOverlays);
        if (this.mCurrentTheme != null) {
            this.setSystemChromeSystemUIOverlayStyle(this.mCurrentTheme);
        }
    }

    private void restoreSystemChromeSystemUIOverlays() {
        this.updateSystemUiOverlays();
    }

    private void setSystemChromeSystemUIOverlayStyle(JSONObject message) {
        Window window = this.mActivity.getWindow();
        View view = window.getDecorView();
        int flags = view.getSystemUiVisibility();
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                if (!message.isNull("systemNavigationBarIconBrightness")) {
                    String systemNavigationBarIconBrightness;
                    switch (systemNavigationBarIconBrightness = message.getString("systemNavigationBarIconBrightness")) {
                        case "Brightness.dark": {
                            flags |= 0x10;
                            break;
                        }
                        case "Brightness.light": {
                            flags &= 0xFFFFFFEF;
                        }
                    }
                }
                if (!message.isNull("systemNavigationBarColor")) {
                    window.setNavigationBarColor(message.getInt("systemNavigationBarColor"));
                }
            }
            if (Build.VERSION.SDK_INT >= 23) {
                if (!message.isNull("statusBarIconBrightness")) {
                    String statusBarIconBrightness;
                    switch (statusBarIconBrightness = message.getString("statusBarIconBrightness")) {
                        case "Brightness.dark": {
                            flags |= 0x2000;
                            break;
                        }
                        case "Brightness.light": {
                            flags &= 0xFFFFDFFF;
                        }
                    }
                }
                if (!message.isNull("statusBarColor")) {
                    window.setStatusBarColor(message.getInt("statusBarColor"));
                }
            }
            if (!message.isNull("systemNavigationBarDividerColor")) {
                // empty if block
            }
            view.setSystemUiVisibility(flags);
            this.mCurrentTheme = message;
        }
        catch (JSONException err) {
            Log.i((String)"PlatformPlugin", (String)err.toString());
        }
    }

    private void popSystemNavigator() {
        this.mActivity.finish();
    }

    private JSONObject getClipboardData(String format) throws JSONException {
        ClipboardManager clipboard = (ClipboardManager)this.mActivity.getSystemService("clipboard");
        ClipData clip = clipboard.getPrimaryClip();
        if (clip == null) {
            return null;
        }
        if (format == null || format.equals(kTextPlainFormat)) {
            JSONObject result = new JSONObject();
            result.put("text", (Object)clip.getItemAt(0).coerceToText((Context)this.mActivity));
            return result;
        }
        return null;
    }

    private void setClipboardData(JSONObject data) throws JSONException {
        ClipboardManager clipboard = (ClipboardManager)this.mActivity.getSystemService("clipboard");
        ClipData clip = ClipData.newPlainText((CharSequence)"text label?", (CharSequence)data.getString("text"));
        clipboard.setPrimaryClip(clip);
    }

    @Override
    public void onPostResume() {
        this.updateSystemUiOverlays();
    }
}

