#!/system/bin/sh
busybox date -s 201501010000.00

HIETHENABLE=`getprop persist.sys.doublenet`
case $HIETHENABLE in
 true)
  ip link add link eth0 eth1 type macvlan
  ;;
 esac

# OptimizedNetwork
test -f /system/bin/hioptimizednetwork && /system/bin/hioptimizednetwork

QBENABLE=`getprop persist.sys.qb.enable`
case $QBENABLE in
 true)
  ;;
 *)
  setprop sys.insmod.ko 1
  ;;
 esac

echo "\n\nWelcome to HiAndroid\n\n" > /dev/kmsg
LOW_RAM=`getprop ro.config.low_ram`
case $LOW_RAM in
 true)
  echo "\n\nenter low_ram mode\n\n" > /dev/kmsg
  #modules(memopt): Enable KSM in low ram device
  echo 1 > /sys/kernel/mm/ksm/run
  echo 300 > /sys/kernel/mm/ksm/sleep_millisecs
  ;;
 *)
  ;;
 esac

# active zram as swap zone, and set zramsize = 100M
echo 104857600 > /sys/block/zram0/disksize
mkswap /dev/block/zram0
swapon /dev/block/zram0
 
#syslog
#logcat -v threadtime -r2048 -n1 -f /tmp/capture/logcat.txt &
#udp
echo "42240 56320 1048576" > /proc/sys/net/ipv4/udp_mem
 
# add for default igmp version is 2 begin
echo "2" > /proc/sys/net/ipv4/conf/default/force_igmp_version
echo "2" > /proc/sys/net/ipv4/conf/eth0/force_igmp_version
# add for default igmp version is 2 end

#feature: set memsize for settings 
MemTotal=`cat /proc/meminfo | grep MemTotal | busybox awk '{print $2}'`
if [ $MemTotal -lt 12000000 ];then
    setprop ro.total.memsize "1G"
elif [ $FlashTotal -lt 22000000 ];then
    setprop ro.total.memsize "2G"
else
    setprop ro.total.memsize "1G"
fi

# 2016.05.05
FlashTotal=`busybox fdisk -l /dev/block/mmcblk0| grep mmcblk0: | busybox awk '{print $3}'`
if [ $FlashTotal -lt 4096 ];then
    setprop ro.total.flash "4G"
elif [ $FlashTotal -lt 8192 ];then
    setprop ro.total.flash "8G"
elif [ $FlashTotal -lt 16384 ];then
    setprop ro.total.flash "16G"
else
    setprop ro.total.flash "4G"
fi

CONSOLEABLE=`getprop persist.sys.console.enable`
FACTORYFILE="/params/factory_enable"
if [ -f ${FACTORYFILE} ];then
    setprop ctl.start console
    setprop ctl.start adbd
    /system/bin/opt/bin/busybox telnetd -l /system/bin/sh &
elif [ "${CONSOLEABLE}" == "0" ];then
      setprop ctl.stop console
fi

/system/bin/opt/etc/init.fhservice.sh&

#Begin:add by liang for convergence devices 2017-8-16
DEVICEMODEL=`getprop ro.product.model`
if [ ${DEVICEMODEL:0:2} == "MR" -o ${DEVICEMODEL:0:2} == "H1" ];then	
    REMOTEADDRESS=`getprop ro.communication.ip`
	if [ "$REMOTEADDRESS" == "" ];then
        busybox ifconfig eth0:1 192.168.125.253 netmask 255.255.255.0 up
        busybox route add -net 192.168.125.0/24 dev eth0:1
    else
        LOCALADDRESS=`echo ${REMOTEADDRESS%.*}`.253
        ROUTEADDRESS=`echo ${REMOTEADDRESS%.*}`.0
        busybox ifconfig eth0:1 ${LOCALADDRESS} netmask 255.255.255.0 up
        busybox route add -net ${ROUTEADDRESS}/24 dev eth0:1
    fi
fi
#End 2017-8-16

#net led
/system/bin/sample_ipcfg &

DEF_FILE="/system/opt/etc/backup.dat"
TAGET_FILE="/params/backup.dat"
DEF_CRC=`busybox awk  '!/^$/{x++}END{print  x}' $DEF_FILE`
TAGET_CRC=`busybox awk  '!/^$/{x++}END{print  x}' $TAGET_FILE`

if [ ! -f $TAGET_FILE ] || [ "$TAGET_CRC" == "0" ]; then
    cp $DEF_FILE $TAGET_FILE
fi
chmod 666 $TAGET_FILE

FactoryEnable_FILE="/params/factory_enable"
FactoryFinish_FILE="/params/factory_finish"
PORTCONFLICT=`getprop ro.fix.portconfilict`
echo "PORTCONFLICT=== ${PORTCONFLICT}"
if [ -f $FactoryEnable_FILE ] && [ ! -f $FactoryFinish_FILE ] && [ "$PORTCONFLICT" == "1" ] ; then
    /system/bin/nc -l 8888 &
fi