#!/system/bin/sh
if [ $1 == "mac" ];then
	num=18
elif [ $1 == "stbid" ];then
	num=33
elif [ $1 == "deviceid" ];then
	num=16
fi
echo $num
i=1
while [ $i -ne $num ]
do
        char=`echo $2 | busybox cut -c $i`
        out0=$out0$char
        ((i++))
done
cd /system/bin/
./write_hardware_info $1 $out0 

function load_driver {
	if [ -f $1 ]; then
		insmod $1
	fi
}

finalmac=
function product_wifi_bt_mac {
	
	echo "product_wifi_bt_mac $1"
	
	mac1=`echo $1 | busybox cut -c 1-2`
	mac2=`echo $1 | busybox cut -c 4-5`
	mac3=`echo $1 | busybox cut -c 7-8`
	mac4=`echo $1 | busybox cut -c 10-11`
	mac5=`echo $1 | busybox cut -c 13-14`
	mac6=`echo $1 | busybox cut -c 16-17`

	tempmac=$mac1$mac2$mac3$mac4$mac5$mac6
	tempmac1=`busybox expr substr "$tempmac" 1 6`
	tempmac2=`busybox expr substr "$tempmac" 7 12`
	if [ $tempmac2 = "FFFFFF" ];then
	    tempmac2="000000"
	    temp1=$((16#${tempmac1}+1))
	    tempmac1=`busybox printf "%06x" $temp1`
	else
	    temp2=$((16#${tempmac2}+1))
	    tempmac2=`busybox printf "%06x" $temp2`
	fi
	finalmac=$tempmac1$tempmac2
	echo $finalmac
}


#update wifi mac for factory
if [ $1 == "mac" ];then
svc wifi disable
sleep 1

load_driver /system/lib/modules/cfg80211.ko
load_driver /system/lib/modules/rtl8192eu.ko
load_driver /system/lib/modules/rtl8188eu.ko
load_driver /system/lib/modules/rtl8811au.ko
load_driver /system/lib/modules/wlan_mt7668_sdio.ko

ifconfig wlan0 up

product_wifi_bt_mac $2

iwpriv wlan0 efuse_set mac,$finalmac

wifimac=`echo $finalmac | busybox tr a-z A-Z`
wmac=$(echo "${wifimac:0:2}:${wifimac:2:2}:${wifimac:4:2}:${wifimac:6:2}:${wifimac:8:2}:${wifimac:10:2}")

unset finalmac
product_wifi_bt_mac $wmac

btmac=`echo $finalmac | busybox tr a-z A-Z`
bmac=$(echo "${btmac:0:2}:${btmac:2:2}:${btmac:4:2}:${btmac:6:2}:${btmac:8:2}:${btmac:10:2}")
echo $bmac

if [ -f /system/bin/wifitest ];then
	/system/bin/wifitest -O
	/system/bin/wifitest -z "W $wmac"
	/system/bin/wifitest -z "B $bmac"
else	
	echo "wifitest not exist"
fi

sync
sync

fi
