/*
	Copyright (c) 2013-2014 EasyDarwin.ORG.  All rights reserved.
	Github: https://github.com/EasyDarwin
	WEChat: EasyDarwin
	Website: http://www.easydarwin.org
	Author: Sword@easydarwin.org
*/
#pragma once

#include <queue>

#include "libEasyPlayerAPI.h"
#include "EasyRTMPClient\EasyRTMPClientAPI.h"
#include "FFDecoder\FFDecoderAPI.h"
#include "D3DRender\D3DRenderAPI.h"
#include "SoundPlayer.h"
#include "ssqueue.h"
#pragma comment(lib, "EasyRTMPClient/libEasyRTMPClient.lib")
#pragma comment(lib, "FFDecoder/FFDecoder.lib")
#pragma comment(lib, "D3DRender/D3DRender.lib")

#include "IntelHardCodec/IntelHardCodec_Interface.h"
#pragma comment(lib, "IntelHardCodec/IntelHardCodec.lib")

// MP4box֧ [9/20/2016 dingshuai]
//gpac write mp4 file
#include "EasyMP4Writer/EasyMP4Writer.h"

#ifdef __cplusplus 
extern "C"
{
#endif
#include "mp4creator\libmp4creator.h"
//#pragma comment(lib, "libMp4Creator.lib")

#include "libavutil/avstring.h"
#include "libavutil/eval.h"
#include "libavutil/mathematics.h"
#include "libavutil/pixdesc.h"
#include "libavutil/imgutils.h"
#include "libavutil/dict.h"
#include "libavutil/parseutils.h"
#include "libavutil/samplefmt.h"
#include "libavutil/avassert.h"
#include "libavutil/time.h"
#include "libavformat/avformat.h"
#include "libavdevice/avdevice.h"
#include "libswscale/swscale.h"
#include "libavutil/opt.h"
#include "libavcodec/avfft.h"
#include "libswresample/swresample.h"

#ifdef __cplusplus 
	}
#endif

#define		MAX_CHANNEL_NUM		64		//Խʾͨ
#define		MAX_DECODER_NUM		5		//һ߳
#define		MAX_YUV_FRAME_NUM	3		//YUV֡
#define		MAX_CACHE_FRAME		30		//֡,ֵֻI֡
//#define		MAX_AVQUEUE_SIZE	(1024*1024)	//дС
#define		MAX_AVQUEUE_SIZE	(1920*1080*2)	//дС

typedef struct __CODEC_T
{
	//Video Codec
	unsigned int	vidCodec;
	int				width;
	int				height;
	int				fps;
	float			bitrate;

	//Audio Codec
	unsigned int	audCodec;
	int				samplerate;
	int				channels;
}CODEC_T;
typedef struct __DECODER_OBJ
{
	bool bHardDecode;
	CODEC_T			codec;
	FFD_HANDLE		ffDecoder;
	LPIntelHardDecoder pIntelDecoder;
	int				yuv_size;
}DECODER_OBJ;


typedef struct __THREAD_OBJ
{
	int			flag;
	HANDLE		hThread;
}THREAD_OBJ;

typedef struct _YUV_FRAME_INFO			//YUVϢ
{
	EASY_FRAME_INFO	frameinfo;
	char	*pYuvBuf;
	int		Yuvsize;
}YUV_FRAME_INFO;

typedef struct tagRECORD_FRAME_INFO
{
	tagRECORD_FRAME_INFO() : pDataBuffer(NULL)
		, nBufSize(0), nTimestamp(0),bIsVideo(FALSE),nID(-1)
	{

		//Ƶ
		memset(&mediaInfo, 0x00, sizeof(EASY_FRAME_INFO));
	}
	tagRECORD_FRAME_INFO& operator=(const tagRECORD_FRAME_INFO& src)
	{
		pDataBuffer	 = src.pDataBuffer;
		nBufSize     = src.nBufSize;
		nTimestamp   = src.nTimestamp;
		bIsVideo	=	src.bIsVideo;
		nID			=	src.nID;
		//Ƶ
		memcpy(&mediaInfo, &src.mediaInfo, sizeof(EASY_FRAME_INFO) );
	}
	//ṹϢ
	unsigned char* pDataBuffer;
	int nBufSize;
	long nTimestamp;//ʱ
	bool bIsVideo;//ʶǷΪƵ
	bool bKeyFrame;//ʶǷΪؼ֡(ƵЧ)
	int nID;//ļID
	// ƵϢ
	EASY_FRAME_INFO mediaInfo;
}RECORD_FRAME_INFO;

typedef std::queue<RECORD_FRAME_INFO*> QueueFrame;

typedef struct __PLAY_THREAD_OBJ
{
	THREAD_OBJ		decodeThread;		//߳
	THREAD_OBJ		displayThread;			//ʾ߳
	THREAD_OBJ		recordThread;			//¼߳
	// 
	Easy_Handle		nvsHandle;
	HWND			hWnd;				//ʾƵĴھ
	int				channelId;			//ͨ
	int				showStatisticalInfo;//ʾͳϢ
	int				showOSD;//ʾOSDϢ
	//OSDԶ
	EASY_PALYER_OSD osd;

	int				frameCache;		//֡(ڵ),ϲӦ
	int				initQueue;		//ʼбʶ
	SS_QUEUE_OBJ_T	*pAVQueue;		//rtsp֡
	int				frameQueue;		//е֡
	int				findKeyframe;	//ǷҪҹؼ֡ʶ
	int				decodeYuvIdx;

	DWORD			dwLosspacketTime;	//ʱ
	DWORD			dwDisconnectTime;	//ʱ

	DECODER_OBJ		decoderObj[MAX_DECODER_NUM];
	D3D_HANDLE		d3dHandle;		//ʾ
	D3D_SUPPORT_FORMAT	renderFormat;	//ʾʽ
	int				ShownToScale;		//ʾ
	int				decodeKeyFrameOnly;	//ʾؼ֡

	unsigned int	rtpTimestamp;
	LARGE_INTEGER	cpuFreq;		//cpuƵ
	_LARGE_INTEGER	lastRenderTime;	//ʾʱ

	int				yuvFrameNo;		//ǰʾyuv֡
	YUV_FRAME_INFO	yuvFrame[MAX_YUV_FRAME_NUM];
	CRITICAL_SECTION	crit;
	bool			resetD3d;		//ǷҪؽd3dRender
	RECT			rcSrcRender;
	D3D9_LINE		d3d9Line;
	
	char			url[MAX_PATH];//ŵURL·
	char			manuRecordingPath[MAX_PATH];//¼·
	char			strScreenCapturePath[MAX_PATH];//ץͼ·
	//char			manuRecordingFile[MAX_PATH];
	int				manuRecording;	//=1 ¼
	int				manuScreenshot;//=1 ץͼ
	//MP4CreatorдMP4
	MP4C_Handler	mp4cHandle;
	//MP4Box Writer
	EasyMP4Writer* m_pMP4Writer;
	int				vidFrameNum;
	MediaSourceCallBack pCallback;
	void			*pUserPtr;

	//¼񻺴֡
	int				initRecQueue;		//ʼбʶ
	SS_QUEUE_OBJ_T	*pRecAVQueue;		//rtsp֡
	CRITICAL_SECTION	critRecQueue;	

	unsigned int bitrateTotalTime;
	unsigned int bitrateTotal;
	unsigned int bitrate;
	unsigned int	uiTimestampTotalFps ;
	int		decodeFpsTotal;
	int fps;

}PLAY_THREAD_OBJ;


//Ƶ߳
typedef struct __AUDIO_PLAY_THREAD_OBJ
{
	int				channelId;		//ǰͨ

	unsigned int	samplerate;	//
	unsigned int	audiochannels;	//
	unsigned int	bitpersample;

	//CWaveOut		*pWaveOut;
	CSoundPlayer	*pSoundPlayer;
}AUDIO_PLAY_THREAD_OBJ;

//ץͼ߳̽ṹ
typedef struct tagPhotoShotThreadInfo
{
	unsigned char* pYuvBuf;
	int width;
	int height;
	char strPath[512];
	int renderFormat;
}PhotoShotThreadInfo;

class CChannelManager
{
public:
	CChannelManager(void);
	virtual ~CChannelManager(void);

	int		Initial();

	//OpenStream һõͨID
	int		OpenStream(const char *url, HWND hWnd, RENDER_FORMAT renderFormat, int _rtpovertcp, const char *username, const char *password, MediaSourceCallBack callback=NULL, void *userPtr=NULL, bool bHardDecode=true);
	void 	CloseStream(int channelId);
	int		ShowStatisticalInfo(int channelId, int _show);
	int		ShowOSD(int channelId, int _show, EASY_PALYER_OSD osd);
	int		SetFrameCache(int channelId, int _cache);
	int		SetShownToScale(int channelId, int ShownToScale);
	int		SetDecodeType(int channelId, int _decodeKeyframeOnly);
	int		SetRenderRect(int channelId, LPRECT lpSrcRect);
	int		DrawLine(int channelId, LPRECT lpRect);
	int		SetDragStartPoint(int channelId, POINT pt);
	int		SetDragEndPoint(int channelId, POINT pt);
	int		ResetDragPoint(int channelId);

	//ͬһʱֻ֧һ·
	int		PlaySound(int channelId);
	int		StopSound();

	int		StartManuRecording(int channelId);
	int		StopManuRecording(int channelId);

	int		SetManuRecordPath(int channelId, const char* recordPath);
	int		SetManuPicShotPath(int channelId, const char* shotPath);

	int		StartManuPicShot(int channelId);//pThread->manuScreenshot
	int		StopManuPicShot(int channelId);

	static LPTHREAD_START_ROUTINE __stdcall _lpDecodeThread( LPVOID _pParam );
	static LPTHREAD_START_ROUTINE __stdcall _lpDisplayThread( LPVOID _pParam );
	static LPTHREAD_START_ROUTINE __stdcall _lpPhotoShotThread( LPVOID _pParam );
	static LPTHREAD_START_ROUTINE __stdcall _lpRecordThread( LPVOID _pParam );


	int		ProcessData(int _chid, int mediatype, char *pbuf, EASY_FRAME_INFO *frameinfo);
	static bool ConvertImage(AVPixelFormat eInFormat, int iInWidth, int iInHeight, void* ptInData,
		AVPixelFormat eOutFormat, int iOutWidth, int iOutHeight, unsigned char** pOutData);

protected:
	bool				GetD3DSupportFormat();			//ȡD3Dֵ֧ĸʽ
	void	CreatePlayThread(PLAY_THREAD_OBJ	*_pPlayThread);
	void	ClosePlayThread(PLAY_THREAD_OBJ		*_pPlayThread);
	void CreateRecordThread(PLAY_THREAD_OBJ	*_pPlayThread);
	void CloseRecordThread(PLAY_THREAD_OBJ	*_pPlayThread);

	int		SetAudioParams(unsigned int _channel, unsigned int _samplerate, unsigned int _bitpersample);
	void	ClearAllSoundData();
	void	Release();	
	
private:
	PLAY_THREAD_OBJ			*pRealtimePlayThread;		//ʵʱ߳
	AUDIO_PLAY_THREAD_OBJ	*pAudioPlayThread;			//Ƶ߳
	CRITICAL_SECTION		crit;
	D3D_ADAPTER_T		d3dAdapter;
	bool m_bIFrameArrive;
};
extern CChannelManager	*pChannelManager;
