#include "Stdafx.h"
#include <OLECtl.h>
#include "GIFImage.h"

//////////////////////////////////////////////////////////////////////////

//캯
CGIFImage::CGIFImage()
{
	//ñ
	m_wImageWidth=0;
	m_wImageHeight=0;
	m_nCurrentFrame=0;
	m_crBackGroundColor=RGB(255,255,255);

	return;
}

//
CGIFImage::~CGIFImage()
{
	//ͷͼ
	DestroyImage();

	return;
}

//ض
bool CGIFImage::LoadFromFile(LPCTSTR pszFileName)
{
	//Ч
	ASSERT(pszFileName!=NULL);
	if (pszFileName==NULL) return false;

	//ͷͼ
	DestroyImage();

	//ļ
	CFile GIFFile;
	if (GIFFile.Open(pszFileName,CFile::modeRead|CFile::shareDenyWrite)==FALSE)
	{
		ASSERT(FALSE);
		return false;
	}

	//ڴ
	DWORD dwFileSize=(DWORD)GIFFile.GetLength();
	BYTE * pcbData=(BYTE *)GlobalAlloc(GMEM_FIXED,dwFileSize);

	//Ч
	ASSERT(pcbData!=NULL);
	if (pcbData==NULL) return false;
	
	//ȡļ
	GIFFile.Read(pcbData,dwFileSize);
	GIFFile.Close();

	//ض
	bool bSuccess=LoadFromMemroy(pcbData,dwFileSize);

	//ͷڴ
	GlobalFree(pcbData);

	return bSuccess;
}

//ض
bool CGIFImage::LoadFromMemroy(BYTE * pcbData, LONG lDataSize)
{
	//ЧС
	ASSERT(pcbData!=NULL);
	ASSERT(lDataSize>=sizeof(tagGIFHeader));
	if ((pcbData==NULL)||(lDataSize<sizeof(tagGIFHeader))) return false;

	//ͷͼ
	DestroyImage();

	//
	tagImageDataInfo ImageDataInfo;
	ZeroMemory(&ImageDataInfo,sizeof(ImageDataInfo));

	//ñ
	ImageDataInfo.lDataSize=lDataSize;
	ImageDataInfo.cbImageDataBuffer=pcbData;

	//жļ
	tagGIFHeader * pGIFHeader=(tagGIFHeader *)pcbData;
	if (memcmp(&pGIFHeader->cbSignature,"GIF",3)!= 0) return false;
	if ((memcmp(&pGIFHeader->cbVersion,"87a",3)!= 0)&&(memcmp(&pGIFHeader->cbVersion,"89a",3)!= 0)) return false;

	//߼Ļ
	tagGIFLSDescriptor * pGIFLSDescriptor=(tagGIFLSDescriptor *)(pcbData+sizeof(tagGIFHeader));
	if (GetPackedValue(pGIFLSDescriptor,LSD_PACKED_GLOBALCT)==1)
	{
		ImageDataInfo.lColorTableSize=3*(1<<(GetPackedValue(pGIFLSDescriptor,LSD_PACKED_GLOBALCTSIZE)+1));
		BYTE * pcbBkColor=pcbData+sizeof(tagGIFHeader)+sizeof(tagGIFLSDescriptor)+3*pGIFLSDescriptor->cbBkIndex;
		m_crBackGroundColor=RGB(pcbBkColor[0],pcbBkColor[1],pcbBkColor[2]);
	};

	//ñ
	tagGIFFrameInfo GIFFrameInfo;
	enGIFBlockTypes GIFBlockTypes;
	m_GIFFrameInfoArray.RemoveAll();
	m_wImageWidth=pGIFLSDescriptor->wWidth;
	m_wImageHeight=pGIFLSDescriptor->wHeight;
	ImageDataInfo.lCurentPos=sizeof(tagGIFHeader)+sizeof(tagGIFLSDescriptor)+ImageDataInfo.lColorTableSize;

	//ͼ֡
	do
	{
		//ȡϢ
		GIFBlockTypes=GetCurrentBlockType(ImageDataInfo);
		if ((GIFBlockTypes==BLOCK_UNKNOWN)||(GIFBlockTypes==BLOCK_TRAILER)) break;

		//
		LONG lStartPos=ImageDataInfo.lCurentPos;
		LONG lBlockSize=GetCurrentBlockSize(ImageDataInfo);

		//ͼο
		if (GIFBlockTypes==BLOCK_CONTROLEXT)
		{
			//
			tagGIFControlExt * pGIFControlExt=(tagGIFControlExt *)(pcbData+ImageDataInfo.lCurentPos);

			//ȡϢ
			GIFFrameInfo.nDelay=pGIFControlExt->wDelayTime;
			GIFFrameInfo.nDisposal=GetPackedValue(pGIFControlExt,GCX_PACKED_DISPOSAL);

			do
			{
				//л
				if (SwitchNextBlock(ImageDataInfo)==false) return false;

				//ȡ
				GIFBlockTypes=GetCurrentBlockType(ImageDataInfo);
				if ((GIFBlockTypes==BLOCK_UNKNOWN)||(GIFBlockTypes==BLOCK_TRAILER)) return false;

				//ж
				lBlockSize+=GetCurrentBlockSize(ImageDataInfo);
				if ((GIFBlockTypes==BLOCK_IMAGE)||(GIFBlockTypes==BLOCK_PLAINTEXT)) break;

			} while (true);
		}
		else 
		{
			GIFFrameInfo.nDisposal=0;
			GIFFrameInfo.nDelay=0xFFFF;
		}

		//ͼ
		if (GIFBlockTypes==BLOCK_IMAGE)
		{
			//
			tagGIFImageDescriptor * pGIFImageDescriptor=(tagGIFImageDescriptor *)(pcbData+ImageDataInfo.lCurentPos);

			//ȡϢ
			GIFFrameInfo.wImageWidth=pGIFImageDescriptor->wWidth;
			GIFFrameInfo.wImageHeight=pGIFImageDescriptor->wHeight;
			GIFFrameInfo.wXExcursion=pGIFImageDescriptor->wXExcursion;
			GIFFrameInfo.wYExcursion=pGIFImageDescriptor->wYExcursion;

			//ڴ
			LONG lAllocSize=sizeof(tagGIFHeader)+sizeof(tagGIFLSDescriptor)+ImageDataInfo.lColorTableSize+lBlockSize+1;
			BYTE * pcbGlobal=(BYTE *)GlobalAlloc(GMEM_FIXED,lAllocSize);
			if (pcbGlobal==NULL) break;

			//ڴ
			LONG lOffset=0L;
			CopyMemory(pcbGlobal,pcbData,sizeof(tagGIFHeader)+sizeof(tagGIFLSDescriptor)+ImageDataInfo.lColorTableSize);
			lOffset+=sizeof(tagGIFHeader)+sizeof(tagGIFLSDescriptor)+ImageDataInfo.lColorTableSize;
			CopyMemory(pcbGlobal+lOffset,pcbData+lStartPos,lBlockSize);
			lOffset+=lBlockSize;
			pcbGlobal[lOffset++]=0x3B;

			//ͼ
			IStream * pIStream=NULL;
			if (CreateStreamOnHGlobal(pcbGlobal,TRUE,&pIStream)!=S_OK)
			{
				ASSERT(FALSE);
				GlobalFree(pcbGlobal);
				break;
			};

			//ͼƬ
			if (OleLoadPicture(pIStream,lOffset,FALSE,IID_IPicture,(VOID * *)&GIFFrameInfo.pIFramePicture)!=S_OK)
			{
				ASSERT(FALSE);
				SafeRelease(pIStream);
				break;
			};

			//ͷԴ
			SafeRelease(pIStream);

			//ͼ֡
			m_GIFFrameInfoArray.Add(GIFFrameInfo);
		}

		//л
		if (SwitchNextBlock(ImageDataInfo)==false) break;

	} while (true);

	return true;
}

//ض
bool CGIFImage::LoadFromResource(LPCTSTR pszResourceName, LPCTSTR pszResourceType)
{
	//Ч
	ASSERT(pszResourceName!=NULL);
	ASSERT(pszResourceType!=NULL);
	if ((pszResourceName==NULL)||(pszResourceType==NULL)) return false;

	//ͷͼ
	DestroyImage();

	//ȡԴ
	HRSRC hPicture=FindResource(AfxGetResourceHandle(),pszResourceName,pszResourceType);
	if (hPicture==NULL) return false;
	HGLOBAL hResData=LoadResource(AfxGetResourceHandle(),hPicture);
	if (hResData=NULL) return false;

	//ڴ
	DWORD dwResourceSize=SizeofResource(AfxGetResourceHandle(),hPicture);
	BYTE * pcbData=(BYTE *)GlobalAlloc(GMEM_FIXED,dwResourceSize);
	if (pcbData==NULL) 
	{
		FreeResource(hResData);
		return false;
	}

	//Դ
	BYTE * pcbSrc=(BYTE *)LockResource(hResData);
	if (pcbSrc==NULL) 
	{
		GlobalFree(pcbData);
		FreeResource(hResData);
		return false;
	}

	//
	CopyMemory(pcbData,pcbSrc,dwResourceSize);
	FreeResource(hResData);

	//ض
	bool bSuccess=LoadFromMemroy(pcbData,dwResourceSize);

	//ͷڴ
	GlobalFree(pcbData);

	return bSuccess;
}

//Ƿ
bool CGIFImage::IsNull()
{
	return (m_GIFFrameInfoArray.GetCount()==0);
}

//ͷͼ
VOID CGIFImage::DestroyImage()
{
	//ñ
	m_wImageWidth=0;
	m_wImageHeight=0;
	m_nCurrentFrame=0;
	m_crBackGroundColor=RGB(255,255,255);

	//ͷͼ֡
	if (m_GIFFrameInfoArray.GetCount()>0)
	{
		for (INT_PTR i=0;i<m_GIFFrameInfoArray.GetCount();i++)
		{
			//ȡ
			tagGIFFrameInfo * pGIFFrameInfo=&m_GIFFrameInfoArray[i];

			//ͷŽӿ
			SafeRelease(pGIFFrameInfo->pIFramePicture);
		}

		//ɾ
		m_GIFFrameInfoArray.RemoveAll();
	}

	return;
}

//ǰͼ
tagGIFFrameInfo * CGIFImage::GetCurrentFrame()
{
	//״̬Ч
	ASSERT(IsNull()==false);
	if (IsNull()==true) return NULL;

	return &m_GIFFrameInfoArray[m_nCurrentFrame];
}

//滭ͼ
VOID CGIFImage::DrawImageFrame(CDC * pDC, INT nXPos, INT nYPos)
{
	//滭ͼƬ
	DrawImageFrame(pDC,nXPos,nYPos,m_nCurrentFrame);

	//ͼ֡
	m_nCurrentFrame=((m_nCurrentFrame+1)==m_GIFFrameInfoArray.GetCount())?0L:(m_nCurrentFrame+1L);

	return;
}

//滭ͼ
VOID CGIFImage::DrawImageFrame(CDC * pDC, INT nXPos, INT nYPos, INT_PTR nFrameIndex)
{
	//ȡ
	ASSERT(nFrameIndex<m_GIFFrameInfoArray.GetCount());
	tagGIFFrameInfo * pGIFFrameInfo=&m_GIFFrameInfoArray[nFrameIndex];

	//ȡС
	OLE_XSIZE_HIMETRIC hmWidth=0L;
	OLE_YSIZE_HIMETRIC hmHeight=0L;
	pGIFFrameInfo->pIFramePicture->get_Width(&hmWidth);
	pGIFFrameInfo->pIFramePicture->get_Height(&hmHeight);

	//滭ͼƬ
	pGIFFrameInfo->pIFramePicture->Render(pDC->m_hDC,nXPos+pGIFFrameInfo->wXExcursion,nYPos+pGIFFrameInfo->wYExcursion,
		pGIFFrameInfo->wImageWidth,pGIFFrameInfo->wImageHeight,0,hmHeight,hmWidth,-hmHeight,NULL);

	return;
}

//鳤
LONG CGIFImage::GetCurrentBlockSize(tagImageDataInfo & ImageDataInfo)
{
	enGIFBlockTypes GIFBlockTypes=GetCurrentBlockType(ImageDataInfo);
	switch (GIFBlockTypes)
	{
	case BLOCK_UNKNOWN: { return -1; }
	case BLOCK_TRAILER: { return 1; }
	case BLOCK_APPEXT:
		{
			LONG lSubSize=GetSubBlockSize(ImageDataInfo,ImageDataInfo.lCurentPos+sizeof(tagGIFAppExtension));
			return sizeof(tagGIFAppExtension)+lSubSize;
		}
	case BLOCK_COMMEXT:
		{
			LONG lSubSize=GetSubBlockSize(ImageDataInfo,ImageDataInfo.lCurentPos+sizeof(tagGIFCommentExt));
			return sizeof(tagGIFCommentExt)+lSubSize;
		}
	case BLOCK_CONTROLEXT:
		{
			return sizeof(tagGIFControlExt);
		}
	case BLOCK_PLAINTEXT:
		{
			LONG lSubSize=GetSubBlockSize(ImageDataInfo,ImageDataInfo.lCurentPos+sizeof(tagGIFPlainTextExt));
			return sizeof(tagGIFPlainTextExt)+lSubSize;
		}
	case BLOCK_IMAGE:
		{
			INT nLCTSize=0;
			tagGIFImageDescriptor * pGIFImageDescriptor=(tagGIFImageDescriptor *)(ImageDataInfo.cbImageDataBuffer+ImageDataInfo.lCurentPos);
			if (GetPackedValue(pGIFImageDescriptor,ID_PACKED_LOCALCT)==1)
			{
				nLCTSize=(1<<(GetPackedValue(pGIFImageDescriptor,ID_PACKED_LOCALCTSIZE)+1))*3;
			}
			LONG lSubSize=GetSubBlockSize(ImageDataInfo,ImageDataInfo.lCurentPos+sizeof(tagGIFImageDescriptor)+nLCTSize+1);
			return sizeof(tagGIFImageDescriptor)+nLCTSize+lSubSize+1;
		}
	};

	return 0;
}

//ȡ
enGIFBlockTypes CGIFImage::GetCurrentBlockType(tagImageDataInfo & ImageDataInfo)
{
	switch (ImageDataInfo.cbImageDataBuffer[ImageDataInfo.lCurentPos])
	{
	case 0x21:
		{
			switch (ImageDataInfo.cbImageDataBuffer[ImageDataInfo.lCurentPos+1])
			{
			case 0x01: { return BLOCK_PLAINTEXT; }
			case 0xF9: { return BLOCK_CONTROLEXT; }
			case 0xFE: { return BLOCK_COMMEXT; }
			case 0xFF: { return BLOCK_APPEXT; }
			};
			break;
		}
	case 0x3B: { return BLOCK_TRAILER; }
	case 0x2C: { return BLOCK_IMAGE; }
	}

	return BLOCK_UNKNOWN;
}

//鳤
LONG CGIFImage::GetSubBlockSize(tagImageDataInfo & ImageDataInfo,LONG lBlockPos)
{
	LONG lBlockLength=0;
	while (ImageDataInfo.cbImageDataBuffer[lBlockPos]!=0)
	{
		lBlockLength+=ImageDataInfo.cbImageDataBuffer[lBlockPos]+1;
		lBlockPos+=ImageDataInfo.cbImageDataBuffer[lBlockPos]+1;
	};
	return lBlockLength+1;
}

//л
bool CGIFImage::SwitchNextBlock(tagImageDataInfo & ImageDataInfo)
{
	LONG lBlockSize=GetCurrentBlockSize(ImageDataInfo);
	if ((lBlockSize<=0)||((ImageDataInfo.lCurentPos+lBlockSize)>ImageDataInfo.lDataSize)) return false;
	ImageDataInfo.lCurentPos+=lBlockSize;
	return true;
}

//ȡֵ
INT CGIFImage::GetPackedValue(const tagGIFControlExt * pGIFControlExt, enum enControlExtValues Value)
{
	switch (Value)
	{
	case GCX_PACKED_DISPOSAL:		//÷
		{
			return (pGIFControlExt->cbPacked&28)>>2;
		}
	case GCX_PACKED_USERINPUT:		//־
		{
			return (pGIFControlExt->cbPacked&2)>>1;
		}
	case GCX_PACKED_TRANSPCOLOR:	//͸־
		{
			return pGIFControlExt->cbPacked&1;
		}
	};

	ASSERT(FALSE);

	return 0;
}

//ȡֵ
INT CGIFImage::GetPackedValue(const tagGIFImageDescriptor * pGIFImageDescriptor, enum enIDPackedValues Value)
{
	switch (Value)
	{
	case ID_PACKED_LOCALCT:		//ɫ־
		{
			return pGIFImageDescriptor->cbPacked>>7;
		}
	case ID_PACKED_INTERLACE:	//֯־
		{
			return (pGIFImageDescriptor->cbPacked&0x40)>>6;
		}
	case ID_PACKED_SORT:		//־
		{
			return (pGIFImageDescriptor->cbPacked&0x20)>>5;
		}
	case ID_PACKED_LOCALCTSIZE:	//ɫС
		{
			return pGIFImageDescriptor->cbPacked&7;
		}
	};

	ASSERT(FALSE);

	return 0;
}

//ȡֵ
INT CGIFImage::GetPackedValue(const tagGIFLSDescriptor * pGIFLSDescriptor, enum enLSDPackedValues Value)
{
	switch (Value)
	{
	case LSD_PACKED_GLOBALCT:		//ɫ־
		{
			return pGIFLSDescriptor->cbPacked>>7;
		}
	case LSD_PACKED_CRESOLUTION:	//ɫ
		{
			return ((pGIFLSDescriptor->cbPacked&0x70)>>4)+1;
		}
	case LSD_PACKED_SORT:			//־
		{
			return (pGIFLSDescriptor->cbPacked&8)>>3;
		}
	case LSD_PACKED_GLOBALCTSIZE:	//ȫɫ
		{
			return pGIFLSDescriptor->cbPacked & 0x07;
		}
	};

	ASSERT(FALSE);

	return 0;
}

//////////////////////////////////////////////////////////////////////////
