package com.aplayer.aplayerandroid;
import java.lang.ref.WeakReference;

import android.util.Log;
import android.util.TypedValue;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.SurfaceHolder;
import android.view.Gravity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.app.Activity;
import android.widget.TextView;
import android.widget.FrameLayout;
import android.os.Looper;
import android.os.Handler;
import android.os.Message;
import android.os.Build;
import android.media.MediaPlayer;
import java.io.IOException;

public class APlayerAndroid {
	
	private static final String TAG = APlayerAndroid.class.getSimpleName();
	SurfaceHolder  msurholder; 
	SurfaceView    msurfaceview;
	TextView       msubtilteview = null;
	int            mSurfaceWidth,mSurfaceHeight;  
	Surface 	   msurface;
	MediaPlayer    mp = null;
	boolean        mis_success = false;
	
	public APlayerAndroid()
	{	
		Log.e(TAG,"APlayerAndroid construct");
		
		Looper looper = Looper.myLooper();
		if(looper == null) {
			looper = Looper.getMainLooper();
		}
		if(looper != null) {
			mEventHandler = new EventHandler(this, looper);
		}
		else {
			mEventHandler = null;
		}
		
		try
		{
			System.loadLibrary("aplayer_ffmpeg");
			if (Build.VERSION.SDK_INT > Build.VERSION_CODES.FROYO)
			{
				Log.e(TAG,"loadLibrary aplayer_android_23");
				System.loadLibrary("aplayer_android_23");
			}
			else
			{
				Log.e(TAG,"loadLibrary aplayer_android_22");
				System.loadLibrary("aplayer_android_22");
			}
		}
		catch (UnsatisfiedLinkError e)
		{
			Log.e(TAG,"loadLibrary aplayer_android fail");
		}
		native_init(new WeakReference<APlayerAndroid>(this));
	}
	
	
	public int SetView(SurfaceView surfaceview)
	{
		msurfaceview = surfaceview;
		mSurfaceWidth   = msurfaceview.getWidth();
		mSurfaceHeight  = msurfaceview.getHeight();
		msurfaceview.getHolder().addCallback(new SurfaceHolder.Callback() {
			public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
				Log.v("APlayerAndroid", "surfaceChanged format=" + format + ", width=" + width + ", height="
			            + height);
				mSurfaceWidth   = width;
				mSurfaceHeight  = height;
			}
			
			public void surfaceCreated(SurfaceHolder holder) {
				msurface = holder.getSurface();
			    native_setdisplay(msurface);
			}
			
			public void surfaceDestroyed(SurfaceHolder holder) {
			    }
			
			});
		return 0;
	}
	
	
	
	
	public int Open(String path)
	{
		mis_success = false;
		mp = null;
		if(is_mp4_format(path)){
			Log.e(TAG,"mediaplayer play");
			mp = new MediaPlayer();
			mp.setSurface(msurface);
			try
        	{
				mp.setDataSource(path);
				mp.prepareAsync();
				mp.setOnPreparedListener(new MediaPlayer.OnPreparedListener() {
					public void onPrepared(MediaPlayer mp) {
						OnOpenSuccess();
					}
				});
        	}
        	catch(IOException e)
        	{
        		mp.release();
        		mp = null;
        		Log.e(TAG,"IOException: " + e.toString());
        		return native_open(path);
        	}
			return 1;
		}
		return native_open(path);
	}
	
	
	
	public int Close()
	{
		if(mp != null){
			mp.stop();
			mp.release();
			mp = null;
			return 1;
		}
		return native_close();
	}
	
	public int Play()
	{
		CreateSubtitleView();
		if(mis_success){
			if(mp != null){
				mp.start();
				//mp.setVideoScalingMode(MediaPlayer.VIDEO_SCALING_MODE_SCALE_TO_FIT_WITH_CROPPING);
				return 1;
			}
			return native_play();
		}
		return 0;
	}
	
	public int Pause()
	{
		if(mp != null){
			mp.pause();
			return 1;
		}
		return native_pause();
	}
	
	public String GetVersion()
	{
		return " ";
	}
	
	public int SetCustomLogo(int logo)
	{
		return 0;
	}
	
	public int GetState()
	{
		return native_getState();
	}
	
	public int GetDuration()
	{
		if(mp != null){
			return mp.getDuration();
		}
		return native_getduration();
	}
	
	public int GetPosition()
	{
		if(mp != null){
			return mp.getCurrentPosition();
		}
		return native_getposition();
	}
	
	public int SetPosition(int msec)
	{
		if(mp != null){
			 mp.seekTo(msec);
			 return 1;
		}
		return native_setposition(msec);
	}
	
	public int GetVideoWidth()
	{
		if(mp != null){
			return mp.getVideoWidth();
		}
		return native_getwidth();
	}
	
	public int GetVideoHeight()
	{
		if(mp != null){
			return mp.getVideoHeight();
		}
		return native_getheight();
	}
	
	public int GetVolume()
	{
		return 0;
	}
	
	public int SetVolume(int volume)
	{
		return 0;
	}
	
	public int GetBufferProgress()
	{
		return native_getbufferprogress();
	}
	
	public String GetConfig(int configID)
	{
		switch(configID)
		{
			case CONFIGID.SUBTITLE_SHOW:
				return config_get_subtitle_show();
			case CONFIGID.SUBTITLE_FONT:
				return config_get_subtitle_font();
			case CONFIGID.SUBTITLE_FILE_NAME:
				return config_get_subtitle_file_name();
			default:
				return native_getconfig(configID);
		}
	}
	
	public int SetConfig(int configID,String value)
	{
		Log.e(TAG, "SetConfig " + value);
		switch(configID)
		{
			case CONFIGID.SUBTITLE_SHOW:
				return config_set_subtitle_show(value);
			case CONFIGID.SUBTITLE_FONT:
				return config_set_subtitle_font(value);
			case CONFIGID.SUBTITLE_PLACEMENT:
				return config_set_subtitle_placement(value);
			case CONFIGID.SUBTITLE_FILE_NAME:
				return config_set_subtitle_file_name(value);
			default:
				return native_setconfig(configID,value);
		}
	}
	
	
	public int SetVideoOrientation(int nOrientation)
	{
		 return native_setVideoOrientation(nOrientation);
	}
	
	private int OnOpenSuccess(){
		mis_success = true;
		if(mOnOpenSuccessListener != null){
			mOnOpenSuccessListener.onOpenSuccess();
		}
		return 1;
	}
	
	/*SurfaceView msur2 = null;
	private int ReSetSurfaceView(){
		if(msur2 != null)
			return 1;
		
		Context context = msurfaceview.getContext();
		if (context instanceof Activity)
		{
			int width,height,top,left;
			int SrcSurfaceWidth  = msurfaceview.getWidth();
			int SrcSurfaceHeight = msurfaceview.getHeight();
			int VideoWidth       = GetVideoWidth();
			int VideoHeight      = GetVideoHeight();
			
			double surfac_aspect_ratio = SrcSurfaceWidth * 1.0f / SrcSurfaceHeight;
			double aspect_ratio        = VideoWidth * 1.0f / VideoHeight;
			if(aspect_ratio > surfac_aspect_ratio)
			{
				width  = SrcSurfaceWidth;
				height = (int)(width / aspect_ratio);
				left   = 0;
				top  = (SrcSurfaceHeight - height) / 2;
			}
			else
			{
				height = SrcSurfaceHeight;
				width  = (int)(aspect_ratio * height);
				left   = (SrcSurfaceWidth - width) / 2;
				top    = 0;
			}
			
			FrameLayout.LayoutParams lytp = new FrameLayout.LayoutParams(width,height,Gravity.TOP);
	    	left   = (left + msurfaceview.getLeft());;
	    	top    = (top  + msurfaceview.getTop());
	    	lytp.setMargins(left, top, 0, 0);
	    	
	    	msur2 = new SurfaceView(context);
	    	Activity activity = (Activity)context;
		    activity.addContentView(msur2, lytp);
	    	msurholder = msur2.getHolder();
			msurholder.addCallback(new SurfaceHolder.Callback() {
			public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
				Log.v("APlayerAndroid", "surfaceChanged format=" + format + ", width=" + width + ", height="
			            + height);
			}
			
			public void surfaceCreated(SurfaceHolder holder) {
				Surface surface = holder.getSurface();
			    native_setdisplay(surface);
			}
			
			public void surfaceDestroyed(SurfaceHolder holder) {
			    }
			
			});
			//msur2.setZOrderOnTop(true);
		}
		return 1;
	}*/
	
	String mshow = "1";
	private int  config_set_subtitle_show(String value)
	{
		if(msubtilteview == null)
    		CreateSubtitleView();
    
    	if(msubtilteview == null)
    		return 0;
		
		if(value.equalsIgnoreCase("1")){
			msubtilteview.setVisibility(TextView.VISIBLE);
			mshow = "1";
		}else{
			msubtilteview.setVisibility(TextView.INVISIBLE);
			mshow = "0";
		}
		
		return 1;
	}
	
	private String  config_get_subtitle_show()
	{
		return mshow;
	}
	
	String mfont = "DEFAULT_BOLD;40;4294967295;0";
	private int config_set_subtitle_font(String value)
	{
		if(msubtilteview == null)
    		CreateSubtitleView();
    
    	if(msubtilteview == null)
    		return 0;
		
		String[] fonts =  value.split(";");
		/*for(int i = 0;i < fonts.length;i++){
			Log.e(TAG, "lzmlsfe " + fonts[i]);
		}*/
		
		mfont = value;
		if(fonts.length > 1 && !fonts[0].isEmpty()){
			if(fonts[0].equalsIgnoreCase("DEFAULT_BOLD")){
				msubtilteview.getPaint().setTypeface(Typeface.DEFAULT_BOLD);
			}
			else if(fonts[0].equalsIgnoreCase("MONOSPACE")){
				msubtilteview.getPaint().setTypeface(Typeface.MONOSPACE);
			}
			else if(fonts[0].equalsIgnoreCase("SANS_SERIF")){
				msubtilteview.getPaint().setTypeface(Typeface.SANS_SERIF);
			}
		}
		
		if(fonts.length > 2 && !fonts[1].isEmpty()){
			msubtilteview.setTextSize(TypedValue.COMPLEX_UNIT_PX, Integer.parseInt(fonts[1]));
		}
			
		
		if(fonts.length > 3 && !fonts[2].isEmpty()){
			long color = Long.parseLong(fonts[2]);
			msubtilteview.setTextColor((int)color);
		}
		
		return 1;
	}
	
	
	private String config_get_subtitle_font()
	{
		return mfont;
	}
	
	
	String mfileName = "";
	private int config_set_subtitle_file_name(String value)
	{
		mfileName = value;
		return native_setconfig(CONFIGID.SUBTITLE_FILE_NAME,value);
	}
	
	private String config_get_subtitle_file_name()
	{
		return mfileName;
	}
	
	private int config_set_subtitle_placement(String value)
	{
		if(msubtilteview == null)
    		CreateSubtitleView();
    
    	if(msubtilteview == null)
    		return 0;
    	
		return 1;
	}
	
	private boolean is_mp4_format(String path){
		return false;
		/*if(path.endsWith(".mp4"))
			return true;
		return false;*/
	}
	
	
	private native int    native_open(String strPath);
	
	private native int    native_close();
	
	private native int    native_play();
	
	private native int    native_pause();
	
	private native int 	  native_getState();
	
	private native int    native_setposition(int msec);
	
	private native int    native_getposition();
	
	private native int    native_getwidth();
	
	private native int    native_getheight();
	
	private native String native_getconfig(int configID);
	
	private native int 	  native_setconfig(int configID,String value);
	
	private native int 	  native_setdisplay(Surface surface);
	
	private native int 	  native_init(Object aplayer_this);
	
	private native int 	  native_getduration();
	
	private native int 	  native_setVideoOrientation(int nOrientation);
	
	private native int    native_isseeking();
	
	private native int    native_getbufferprogress();
    
    public interface OnOpenSuccessListener
	{
		void onOpenSuccess();
	}
    public void setOnOpenSuccessListener(OnOpenSuccessListener listener)
    {
    	mOnOpenSuccessListener = listener;
    }
    private OnOpenSuccessListener mOnOpenSuccessListener;
    
    
    public interface OnPlayStateChangeListener
	{
		void onPlayStateChange(int nCurrentState,int nPreState);
	}
    public void setOnPlayStateChangeListener(OnPlayStateChangeListener listener)
    {
    	mOnPlayStateChangeListener = listener;
    }
    private OnPlayStateChangeListener mOnPlayStateChangeListener;
    
    
    public interface OnBufferListener
   	{
   		void onBuffer(int progress);
   	}
    public void setOnBufferListenerr(OnBufferListener listener)
    {
    	mOnBufferListener = listener;
    }
    private OnBufferListener mOnBufferListener;
    
    
    int mSubtitleWidth,mSubtitleHeight,mSubtitleLeft,mSubtitleBottom;
    FrameLayout.LayoutParams lytp;
    private void ShowSubtitle(CharSequence text)
    {    	
    	if(msubtilteview == null)
    		CreateSubtitleView();
    
    	if(msubtilteview == null)
    		return;
    	
    	msubtilteview.setText(text);
    	int lineCount  = msubtilteview.getLineCount();
    	if(lineCount < 1)
    		lineCount = 1;
    	
    	int textViewHeight = lineCount * msubtilteview.getLineHeight();
    	lytp.topMargin    = mSubtitleBottom - textViewHeight;
    	msubtilteview.setLayoutParams(lytp);
    	msubtilteview.setHeight(textViewHeight);
    }
    
    private boolean CreateSubtitleView()
    {
    	if(msubtilteview == null)
    	{
    		if(msurfaceview == null)
    			return false;
    		
    		Context context = msurfaceview.getContext();
    		msubtilteview = new TextView(context);
    		if (context instanceof Activity)
    		{
    			lytp = new FrameLayout.LayoutParams(FrameLayout.LayoutParams.WRAP_CONTENT,FrameLayout.LayoutParams.WRAP_CONTENT);
    			int width,height,top,left;
    	    	double surfac_aspect_ratio = mSurfaceWidth * 1.0f / mSurfaceHeight;
    	    	if(GetVideoWidth() == 0 || GetVideoHeight() == 0){
    	    		return false;
    	    	}
    	    	double m_aspect_ratio = GetVideoWidth() * 1.0f / GetVideoHeight();
    	    	if(m_aspect_ratio > surfac_aspect_ratio)
    	    	{
    	    		width  = mSurfaceWidth;
    	    		height = (int)(width / m_aspect_ratio);
    	    		left   = 0;
    	    		top  = (mSurfaceHeight - height) / 2;
    	    	}
    	    	else
    	    	{
    	    		height = mSurfaceHeight;
    	    		width  = (int)(m_aspect_ratio * height);
    	    		left   = (mSurfaceWidth - width) / 2;
    	    		top    = 0;
    	    	}
    	    	mSubtitleLeft     = (left + msurfaceview.getLeft());
    	    	mSubtitleBottom   = (top  + msurfaceview.getTop() + height);
    	    	lytp.leftMargin   = mSubtitleLeft;
    	    	lytp.topMargin    = mSubtitleBottom;
	    		msubtilteview.setWidth(width);
	    		msubtilteview.setGravity(Gravity.CENTER);
	    		msubtilteview.setTextSize(TypedValue.COMPLEX_UNIT_PX,40);
    		    Activity activity = (Activity)context;
    		    activity.addContentView(msubtilteview, lytp);
    		    msubtilteview.setTextColor(Color.rgb(255, 255, 255));
    		    msubtilteview.setText("");
    		    msubtilteview.setVisibility(TextView.VISIBLE);
    		}
    	}
    	return true;
    }
    
	private class MsgID 
	{
		public static final int PLAY_OPEN_SUCCESSDED 	= 1;
		public static final int PLAY_STATECHANGED       = 5;
		public static final int GET_BUFFERPRO          	= 102;
		public static final int SHOW_SUBTITLE           = 103;
	}
	
	
	public class Orientation
	{
		public static final String VIDEO_ORIENTARION_NORM      = "NORM";
		public static final String VIDEO_ORIENTARION_LEFT90    = "LEFT90";
		public static final String VIDEO_ORIENTARION_RIGHT90   = "RIGHT90";
		public static final String VIDEO_ORIENTARION_LEFT180   = "LEFT180";
	}
	
	
	public class PlayerState
	{
		public static final int APLAYER_READ   		= 0;
		public static final int APLAYER_OPENING   	= 1;
		public static final int APLAYER_PAUSING   	= 2;
		public static final int APLAYER_PAUSED   	= 3;
		public static final int APLAYER_PLAYING   	= 4;
		public static final int APLAYER_PLAY   		= 5;
		public static final int APLAYER_CLOSEING   	= 6;
	}
	
	
	public class CONFIGID
	{
		public static final int PLAYRESULT          	= 7;
		public static final int READPOSITION   			= 31;
		public static final int UPDATEWINDOW        	= 40;		
		public static final int ORIENTATION   			= 41;
		public static final int ASPECT_RATIO_NATIVE     = 203;
		public static final int ASPECT_RATIO_CUSTOM     = 204;
		
		public static final int AUDIO_TRACK_LIST   		= 402;
		public static final int AUDIO_TRACK_CURRENT   	= 403;
		
		public static final int SUBTITLE_USABLE         = 501;
		public static final int SUBTITLE_EXT_NAME       = 502;
		public static final int SUBTITLE_FILE_NAME      = 503;
		public static final int SUBTITLE_SHOW           = 504;
		public static final int SUBTITLE_LANGLIST       = 505;
		public static final int SUBTITLE_CURLANG        = 506;
		public static final int SUBTITLE_PLACEMENT      = 507;
		public static final int SUBTITLE_FONT           = 508;
		public static final int SUBTITLE_SURFACE   		= 512;
		
		public static final int HTTP_COOKIE   			= 1105;
		public static final int HTTP_REFERER   			= 1106;
		public static final int HTTP_CUSTOM_HEADERS   	= 1107;
		public static final int HTTP_USER_AGENT   		= 1108;
		
		public static final int NET_BUFFER_ENTER        = 1001;
		public static final int NET_BUFFER_LEAVE        = 1002;
		public static final int NET_NOBUFFER_DRY        = 1003;
		public static final int NET_SEEKBUFFER_WAITTIME = 1004;
	}
	
	private class EventHandler extends Handler 
	{

		APlayerAndroid mp = null;
		
		public EventHandler(APlayerAndroid mp, Looper looper) 
		{
			super(looper);
			this.mp = mp;
		}
		
		public void handleMessage(Message msg) 
		{
			switch(msg.what) 
			{
			case MsgID.PLAY_OPEN_SUCCESSDED:
				Log.e(TAG, "PLAY_OPEN_SUCCESSDED is received");
				OnOpenSuccess();
				break;
			case MsgID.PLAY_STATECHANGED:
				if(mOnPlayStateChangeListener != null){
					mOnPlayStateChangeListener.onPlayStateChange(msg.arg1,msg.arg2);
				}
				break;
			case MsgID.GET_BUFFERPRO:
				if (mOnBufferListener != null) {
					mOnBufferListener.onBuffer(msg.arg1);
				}
				break;
			case MsgID.SHOW_SUBTITLE:
				if (msg.obj instanceof String)
				{
					String text = (String)msg.obj;
					ShowSubtitle(text);
				}
				break;
			default:
				Log.e(TAG, "Unknown message tyupe " + msg.what);
				break;
			}
		}
	}
	
	private static void postEventFromNative(Object mediaplayer_ref,
	            int what, int arg1, int arg2, Object obj)
	{
	  	APlayerAndroid mp = (APlayerAndroid)((WeakReference)mediaplayer_ref).get();
		if (mp == null) {
			return;
		}
	
		if (mp.mEventHandler != null) 
		{
			Message m = mp.mEventHandler.obtainMessage(what, arg1, arg2, obj);
			m.arg1 = arg1;
			m.arg2 = arg2;
			m.obj  = obj;
			mp.mEventHandler.sendMessage(m);
		}
	}
	
	private EventHandler mEventHandler = null; 
}
