/*
 * Decompiled with CFR 0.152.
 */
package me.add1.common;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParcelUtils {
    public static final int EXIST_SEPARATOR = 1;
    public static final int NON_SEPARATOR = 0;

    public static void writeToParcel(Parcel out, String obj) {
        if (obj != null) {
            out.writeInt(1);
            out.writeString(obj);
        } else {
            out.writeInt(0);
        }
    }

    public static void writeToParcel(Parcel out, Long obj) {
        if (obj != null) {
            out.writeInt(1);
            out.writeLong(obj.longValue());
        } else {
            out.writeInt(0);
        }
    }

    public static void writeToParcel(Parcel out, Integer obj) {
        if (obj != null) {
            out.writeInt(1);
            out.writeInt(obj.intValue());
        } else {
            out.writeInt(0);
        }
    }

    public static void writeToParcel(Parcel out, Float obj) {
        if (obj != null) {
            out.writeInt(1);
            out.writeFloat(obj.floatValue());
        } else {
            out.writeInt(0);
        }
    }

    public static void writeToParcel(Parcel out, Double obj) {
        if (obj != null) {
            out.writeInt(1);
            out.writeDouble(obj.doubleValue());
        } else {
            out.writeInt(0);
        }
    }

    public static void writeToParcel(Parcel out, Map obj) {
        if (obj != null) {
            out.writeInt(1);
            out.writeMap(obj);
        } else {
            out.writeInt(0);
        }
    }

    public static void writeToParcel(Parcel out, Date obj) {
        if (obj != null) {
            out.writeInt(1);
            out.writeLong(obj.getTime());
        } else {
            out.writeInt(0);
        }
    }

    public static Float readFloatFromParcel(Parcel in) {
        int flag = in.readInt();
        if (flag == 1) {
            return Float.valueOf(in.readFloat());
        }
        return null;
    }

    public static Double readDoubleFromParcel(Parcel in) {
        int flag = in.readInt();
        if (flag == 1) {
            return in.readDouble();
        }
        return null;
    }

    public static Date readDateFromParcel(Parcel in) {
        int flag = in.readInt();
        if (flag == 1) {
            return new Date(in.readLong());
        }
        return null;
    }

    public static Integer readIntFromParcel(Parcel in) {
        int flag = in.readInt();
        if (flag == 1) {
            return in.readInt();
        }
        return null;
    }

    public static Long readLongFromParcel(Parcel in) {
        int flag = in.readInt();
        if (flag == 1) {
            return in.readLong();
        }
        return null;
    }

    public static String readFromParcel(Parcel in) {
        int flag = in.readInt();
        if (flag == 1) {
            return in.readString();
        }
        return null;
    }

    public static Map readMapFromParcel(Parcel in) {
        int flag = in.readInt();
        if (flag == 1) {
            return in.readHashMap(HashMap.class.getClassLoader());
        }
        return null;
    }

    public static <T extends Parcelable> T readFromParcel(Parcel in, Class<T> cls) {
        int flag = in.readInt();
        if (flag == 1) {
            return (T)in.readParcelable(cls.getClassLoader());
        }
        return null;
    }

    public static <T extends Parcelable> void writeToParcel(Parcel out, T model) {
        if (model != null) {
            out.writeInt(1);
            out.writeParcelable(model, 0);
        } else {
            out.writeInt(0);
        }
    }

    public static <T extends List<?>> void writeToParcel(Parcel out, T model) {
        if (model != null) {
            out.writeInt(1);
            out.writeList(model);
        } else {
            out.writeInt(0);
        }
    }

    public static <T> ArrayList<T> readListFromParcel(Parcel in, Class<T> cls) {
        int flag = in.readInt();
        if (flag == 1) {
            return in.readArrayList(cls.getClassLoader());
        }
        return null;
    }

    public static void writeListToParcel(Parcel out, List<?> collection) {
        if (collection != null) {
            out.writeInt(1);
            out.writeList(collection);
        } else {
            out.writeInt(0);
        }
    }

    public static <T extends Parcelable> T bytesToParcelable(byte[] data, Class<T> cls) {
        if (data == null || data.length == 0) {
            return null;
        }
        Parcel in = Parcel.obtain();
        in.unmarshall(data, 0, data.length);
        in.setDataPosition(0);
        T t = ParcelUtils.readFromParcel(in, cls);
        in.recycle();
        return t;
    }

    public static byte[] parcelableToByte(Parcelable model) {
        if (model == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        ParcelUtils.writeToParcel(parcel, model);
        return parcel.marshall();
    }

    public static <T extends Parcelable> List<T> bytesToParcelableList(byte[] data, Class<T> cls) {
        if (data == null || data.length == 0) {
            return null;
        }
        Parcel in = Parcel.obtain();
        in.unmarshall(data, 0, data.length);
        in.setDataPosition(0);
        ArrayList<T> t = ParcelUtils.readListFromParcel(in, cls);
        in.recycle();
        return t;
    }

    public static byte[] parcelableListToByte(List<? extends Parcelable> list) {
        if (list == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        ParcelUtils.writeListToParcel(parcel, list);
        return parcel.marshall();
    }
}

