/*
 * Decompiled with CFR 0.152.
 */
package io.rong.voiplib.utils;

import android.content.Context;
import android.util.Log;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.http.conn.util.InetAddressUtils;

public class VoIPUtil {
    public static String getLocalIpAddress(Context context) {
        try {
            ArrayList<NetworkInterface> nilist = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface ni : nilist) {
                if (ni.getName().toLowerCase().contains("usbnet")) continue;
                ArrayList<InetAddress> ialist = Collections.list(ni.getInetAddresses());
                for (InetAddress address : ialist) {
                    String ipv4;
                    if (address.isLoopbackAddress() || !InetAddressUtils.isIPv4Address((String)(ipv4 = address.getHostAddress()))) continue;
                    return ipv4;
                }
            }
        }
        catch (SocketException ex) {
            Log.d((String)"socket_err", (String)ex.toString());
        }
        return null;
    }

    public static int getPort() {
        DatagramSocket s = null;
        int MAXPORT = 65000;
        for (int MINPORT = 10000; MINPORT < MAXPORT; ++MINPORT) {
            try {
                s = new DatagramSocket(MINPORT, InetAddress.getLocalHost());
                s.close();
                return MINPORT;
            }
            catch (IOException e) {
                continue;
            }
        }
        return -1;
    }
}

