/*
 * Decompiled with CFR 0.152.
 */
package io.rong.voipkit.activity;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import io.rong.imkit.RCloudContext;
import io.rong.imkit.model.VOIPCallBackObject;
import io.rong.imkit.utils.RongToast;
import io.rong.imlib.RongIMClient;
import io.rong.voipkit.activity.BaseActivity;
import io.rong.voipkit.message.VoIPCallMessage;
import io.rong.voipkit.message.VoIPFinishMessage;
import io.rong.voiplib.NativeObject;
import io.rong.voiplib.RongIMVoIP;
import io.rong.voiplib.utils.Res;
import io.rong.voiplib.utils.VoIPUtil;

public class CallSideActivity
extends BaseActivity {
    private String peerUserName;
    private TextView userName;
    private ImageView sound_off;
    private ImageView hands_off;
    private View maskView;
    private String myselfName;
    private String token;
    public static final int STARTVOIP_SUCCESS = 0;
    public static final int STARTVOIP_ERROR = 1;
    private static boolean isActiviyShow = false;
    Handler connectedHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what == 0) {
                VoIPCallMessage vcm = (VoIPCallMessage)msg.obj;
                CallSideActivity.this.sendMsg(vcm);
                CallSideActivity.this.playerRingtone(2, 88);
            } else if (msg.what == 1) {
                String info = "\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u5728\u8bd5\uff01\uff01\uff01";
                if (msg.arg1 == 404) {
                    info = "\u5bf9\u65b9\u6b63\u5728\u901a\u8bdd!";
                }
                if (isActiviyShow) {
                    new AlertDialog.Builder((Context)CallSideActivity.this).setTitle((CharSequence)info).setMessage((CharSequence)"\u662f\u5426\u9000\u51fa\u901a\u8bdd\u754c\u9762\uff1f").setPositiveButton((CharSequence)"\u662f", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            CallSideActivity.this.finish();
                        }
                    }).show();
                }
            }
        }
    };
    Handler delayHandler;
    Runnable finishActivity;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(Res.getInstance((Context)this).layout("rc_callside_layout"));
        this.userName = (TextView)this.findViewById(Res.getInstance((Context)this).id("user_name"));
        this.sound_off = (ImageView)this.findViewById(Res.getInstance((Context)this).id("sound_off_id"));
        this.hands_off = (ImageView)this.findViewById(Res.getInstance((Context)this).id("hands_off_id"));
        this.user_photo = (ImageView)this.findViewById(Res.getInstance((Context)this).id("user_photo"));
        this.calling_state = (TextView)this.findViewById(Res.getInstance((Context)this).id("calling_state"));
        this.maskView = this.findViewById(Res.getInstance((Context)this).id("mask_layout"));
        this.reciveIntentData();
        this.userName.setText((CharSequence)this.peerUserName);
        this.setPhoto(this.peerUserPhoteUri);
        this.delayTimesFinish();
        Log.i((String)"fff", (String)("===================called====================mode==" + this.mAudioManager.getMode() + "===" + this.mySelfId + "===" + this.appId + "===" + this.sessionId));
        RCloudContext.getInstance().getEventBus().register((Object)this);
    }

    public void onEvent(VOIPCallBackObject voipCallBackObject) {
        RongIMClient.SendMessageCallback.ErrorCode errorCode;
        if (voipCallBackObject != null && !voipCallBackObject.isSuccess() && voipCallBackObject.getObject() != null && voipCallBackObject.getObject() instanceof RongIMClient.SendMessageCallback.ErrorCode && (errorCode = (RongIMClient.SendMessageCallback.ErrorCode)((Object)voipCallBackObject.getObject())).getValue() == RongIMClient.SendMessageCallback.ErrorCode.REJECTED_BY_BLACKLIST.getValue()) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    RongToast.toast((Context)CallSideActivity.this, CallSideActivity.this.getResources().getString(io.rong.imkit.Res.getInstance((Context)CallSideActivity.this).string("rc_rejected_by_blacklist_voice_prompt")));
                    CallSideActivity.this.finish();
                }
            });
        }
    }

    @Override
    protected void showMaskLayout(boolean isShow) {
        if (isShow) {
            this.maskView.setVisibility(0);
        } else {
            this.maskView.setVisibility(8);
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        isActiviyShow = true;
        this.connectVoIPServer_call();
    }

    private void reciveIntentData() {
        this.appId = this.getIntent().getStringExtra("appId");
        this.token = this.getIntent().getStringExtra("token");
        this.mySelfId = this.getIntent().getStringExtra("mySelfId");
        this.myselfName = this.getIntent().getStringExtra("myselfName");
        this.peerid = this.getIntent().getStringExtra("peerUId");
        this.peerUserName = this.getIntent().getStringExtra("peerUserName");
        this.peerUserPhoteUri = this.getIntent().getStringExtra("peerUserPhoteUri");
    }

    private void connectVoIPServer_call() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                CallSideActivity.this.localPort = VoIPUtil.getPort();
                RongIMVoIP.startVoIP(CallSideActivity.this.appId, CallSideActivity.this.token, CallSideActivity.this.mySelfId, CallSideActivity.this.peerid, CallSideActivity.this.localPort, new NativeObject.StartVoIPCallback(){

                    @Override
                    public void OnSuccess(String sessionId, String ip, String remoteTransferPort, String remoteControlPort) {
                        Log.i((String)"voip", (String)("===============java enter OnSuccess===============" + sessionId + "====" + ip + "===" + remoteTransferPort));
                        CallSideActivity.this.isVoIPSuccess = true;
                        CallSideActivity.this.sessionId = sessionId;
                        CallSideActivity.this.remoteIp = ip;
                        CallSideActivity.this.remotePort = Integer.parseInt(remoteTransferPort);
                        Message msg = CallSideActivity.this.connectedHandler.obtainMessage();
                        VoIPCallMessage vcm = new VoIPCallMessage(sessionId, ip, Integer.parseInt(remoteTransferPort), Integer.parseInt(remoteControlPort), CallSideActivity.this.peerid, CallSideActivity.this.peerUserName, CallSideActivity.this.mySelfId, CallSideActivity.this.myselfName);
                        msg.obj = vcm;
                        msg.what = 0;
                        CallSideActivity.this.connectedHandler.sendMessage(msg);
                    }

                    @Override
                    public void OnError(int errorcode, String description) {
                        Log.i((String)"void", (String)("============java enter OnError=======================" + errorcode + "===" + description));
                        CallSideActivity.this.isVoIPSuccess = false;
                        Message msg = CallSideActivity.this.connectedHandler.obtainMessage();
                        msg.what = 1;
                        msg.arg1 = errorcode;
                        CallSideActivity.this.connectedHandler.sendMessage(msg);
                    }
                });
            }
        }).start();
    }

    public void doFinishChat(View view) {
        Log.i((String)"aff", (String)"======================finishChat==================");
        VoIPFinishMessage vfm = new VoIPFinishMessage(this.peerid);
        vfm.setFinish_state(0);
        this.sendMsg(vfm);
        this.finish();
    }

    public void onBackPressed() {
        VoIPFinishMessage vfm = new VoIPFinishMessage(this.peerid);
        vfm.setFinish_state(0);
        this.sendMsg(vfm);
        super.onBackPressed();
    }

    private void delayTimesFinish() {
        this.delayHandler = new Handler();
        this.finishActivity = new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)CallSideActivity.this, (CharSequence)"\u5bf9\u65b9\u672a\u63a5\u542c\uff01\uff01", (int)1).show();
                VoIPFinishMessage vfm = new VoIPFinishMessage(CallSideActivity.this.peerid);
                vfm.setFinish_state(0);
                CallSideActivity.this.sendMsg(vfm);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                CallSideActivity.this.finish();
            }
        };
        this.delayHandler.postDelayed(this.finishActivity, 60000L);
    }

    public void CalledAcceptCall() {
        Log.i((String)"effaaa", (String)"=========================\u88ab\u53eb\u65b9\u63a5\u53d7\u4e86\u547c\u53eb\u8bf7\u6c42==============================");
        Toast.makeText((Context)this, (CharSequence)"\u5bf9\u65b9\u63a5\u53d7\u4e86\u901a\u8bdd\u8bf7\u6c42\uff01\uff01\uff01", (int)1).show();
        this.delayHandler.removeCallbacks(this.finishActivity);
        this.startCountTime();
        this.releaseRingtong();
        this.createVoIP();
        this.enableHandOffAndSoundOff(this.sound_off, this.hands_off);
    }

    @Override
    protected void onDestroy() {
        RCloudContext.getInstance().getEventBus().unregister((Object)this);
        isActiviyShow = false;
        super.onDestroy();
        this.delayHandler.removeCallbacks(this.finishActivity);
    }
}

