/*
 * Decompiled with CFR 0.152.
 */
package io.rong.voipkit.activity;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.SystemClock;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.ultrapower.mcs.engine.ITransportListener;
import com.ultrapower.mcs.engine.TransportType;
import com.ultrapower.mcs.engine.UMCS;
import com.ultrapower.mcs.engine.UmcsConfig;
import com.ultrapower.mcs.engine.internal.UMCSInternal;
import io.rong.imlib.RongIMClient;
import io.rong.voipkit.activity.CallSideActivity;
import io.rong.voipkit.message.VoIPAcceptMessage;
import io.rong.voipkit.message.VoIPFinishMessage;
import io.rong.voiplib.RongIMVoIP;
import io.rong.voiplib.utils.VoIPUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public abstract class BaseActivity
extends Activity
implements SensorEventListener {
    public static final String RECIVE_MSG_BROADCAST_ACTION = "com.ccrc.avtest.action.reciveMsg";
    protected ReciveMsgBroadCastReciver rmb;
    protected UMCS session = null;
    protected UMCSInternal uUMCSInternal;
    protected AudioManager mAudioManager = null;
    private PowerManager.WakeLock wakeLock = null;
    protected String remoteIp = "";
    protected int localPort;
    protected int remotePort;
    protected String peerid;
    protected String appId;
    protected String mySelfId;
    protected String sessionId;
    protected String peerUserPhoteUri;
    protected boolean isVoIPSuccess = false;
    protected TextView calling_state;
    protected ImageView user_photo;
    protected MediaPlayer mMediaPlayer;
    protected int initAudioMode;
    private Sensor mSensor;
    private SensorManager mSensorManager;
    float mLastEventValue = Float.MIN_VALUE;
    private Handler stepTimeHandler;
    private Runnable mTicker;
    long startTime = 0L;
    public static final int RINGSTYLE_CALL = 88;
    public static final int RINGSTYLE_CALLED = 188;
    private Handler setPhotoHandler = new Handler(){

        public void handleMessage(Message msg) {
            Bitmap bitmap = (Bitmap)msg.obj;
            if (bitmap != null) {
                BaseActivity.this.user_photo.setImageBitmap(bitmap);
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        this.requestWindowFeature(1);
        super.onCreate(savedInstanceState);
        this.rmb = new ReciveMsgBroadCastReciver();
        IntentFilter intentFilter = new IntentFilter(this.getPackageName() + RECIVE_MSG_BROADCAST_ACTION);
        this.registerReceiver(this.rmb, intentFilter);
        this.initAudioManager();
        this.initAudioMode = this.mAudioManager.getMode();
    }

    private void initAudioManager() {
        PowerManager pm = (PowerManager)this.getSystemService("power");
        this.wakeLock = pm.newWakeLock(6, "avtest");
        this.mAudioManager = (AudioManager)this.getSystemService("audio");
        this.wakeLock.acquire();
        this.mSensorManager = (SensorManager)this.getSystemService("sensor");
        this.mSensor = this.mSensorManager.getDefaultSensor(8);
        if (null == this.session) {
            this.session = new UMCS((Context)this);
        }
        if (null == this.uUMCSInternal) {
            this.uUMCSInternal = new UMCSInternal();
        }
    }

    protected void onResume() {
        super.onResume();
        this.mSensorManager.registerListener((SensorEventListener)this, this.mSensor, 3);
    }

    protected void onPause() {
        super.onPause();
        this.mSensorManager.unregisterListener((SensorEventListener)this);
    }

    public void onSensorChanged(SensorEvent event) {
        float value = event.values[0];
        if (this.mLastEventValue == Float.MIN_VALUE) {
            this.mLastEventValue = value;
        }
        if (value > this.mLastEventValue) {
            this.mLastEventValue = value;
        }
        if (value >= this.mLastEventValue) {
            Toast.makeText((Context)this, (CharSequence)"\u6b63\u5e38\u6a21\u5f0f", (int)1).show();
            Log.i((String)"afff", (String)"===================\u6b63\u5e38\u6a21\u5f0f============================");
            this.showMaskLayout(false);
        } else {
            Toast.makeText((Context)this, (CharSequence)"\u542c\u7b52\u6a21\u5f0f", (int)1).show();
            Log.i((String)"afff", (String)"====================\u542c\u7b52\u6a21\u5f0f===========================");
            this.showMaskLayout(true);
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    protected abstract void showMaskLayout(boolean var1);

    protected void initCall() {
        UmcsConfig uConfig = new UmcsConfig();
        uConfig.setMultiMode(false);
        uConfig.setTraceFilter(2);
        uConfig.setTransportType(TransportType.kUdpGernal);
        int ret = this.session.Init(uConfig);
        if (-1 == ret) {
            return;
        }
    }

    protected void createVoIP() {
        this.setVolumeControlStream(0);
        this.initCall();
        this.createLocaleAudio();
        this.createRemoteAudio();
        this.StartChat();
    }

    protected void createLocaleAudio() {
        int ret = this.uUMCSInternal.SetECEnable(1, 4);
        if (-1 == ret) {
            return;
        }
        ret = this.uUMCSInternal.SetNSEnable(1, 6);
        if (-1 == ret) {
            return;
        }
        if (-1 == ret) {
            return;
        }
        ret = this.uUMCSInternal.SetHighPassFilterEnable(1);
        if (-1 == ret) {
            return;
        }
        ret = this.session.CreateLocalAudio(1);
        if (-1 == ret) {
            return;
        }
    }

    protected void createRemoteAudio() {
        int ret = this.session.CreateRemoteAudio(1);
        if (-1 == ret) {
            return;
        }
    }

    protected void StartChat() {
        int ret = 0;
        String localIp = VoIPUtil.getLocalIpAddress((Context)this);
        ret = this.session.StartTransport(localIp, this.localPort, this.remoteIp, this.remotePort, null, new ITransportListener(){

            @Override
            public void OnTransportFailed() {
            }
        });
        ret = this.session.StartSendLocalAudio(1);
        if (-1 == ret) {
            return;
        }
        ret = this.session.StartRecvRemoteAudio(1);
        if (-1 == ret) {
            return;
        }
    }

    protected void sendMsg(RongIMClient.MessageContent mc) {
        Intent intent = new Intent();
        intent.setAction(this.getPackageName() + ".io.rong.imkitvoip.broadcast.SENDMESSAGE");
        intent.putExtra("messageContent", (Parcelable)mc);
        this.sendBroadcast(intent);
    }

    private String showTimeCount(long time) {
        if (time >= 360000000L) {
            return "00:00:00";
        }
        String timeCount = "";
        long hourc = time / 3600000L;
        String hour = "0" + hourc;
        hour = hour.substring(hour.length() - 2, hour.length());
        long minuec = (time - hourc * 3600000L) / 60000L;
        String minue = "0" + minuec;
        minue = minue.substring(minue.length() - 2, minue.length());
        long secc = (time - hourc * 3600000L - minuec * 60000L) / 1000L;
        String sec = "0" + secc;
        sec = sec.substring(sec.length() - 2, sec.length());
        timeCount = hour + ":" + minue + ":" + sec;
        return timeCount;
    }

    public void startCountTime() {
        this.calling_state.setText((CharSequence)"00:00:00");
        this.stepTimeHandler = new Handler();
        this.startTime = System.currentTimeMillis();
        this.mTicker = new Runnable(){

            @Override
            public void run() {
                String content = BaseActivity.this.showTimeCount(System.currentTimeMillis() - BaseActivity.this.startTime);
                BaseActivity.this.calling_state.setText((CharSequence)content);
                long now = SystemClock.uptimeMillis();
                long next = now + (1000L - now % 1000L);
                BaseActivity.this.stepTimeHandler.postAtTime(BaseActivity.this.mTicker, next);
            }
        };
        this.mTicker.run();
    }

    public void stopCountTime() {
        if (this.stepTimeHandler != null) {
            this.stepTimeHandler.removeCallbacks(this.mTicker);
        }
    }

    protected void playerRingtone(int audiaMode, int ringstyle) {
        Log.d((String)"playerNotificationSound", (String)"==================playerNotificationSound============");
        this.setVolumeControlStream(4);
        this.mAudioManager.setMode(audiaMode);
        try {
            String ringname = null;
            ringname = ringstyle == 88 ? "voip_ring_call.mp3" : "voip_ring_called.mp3";
            AssetFileDescriptor fileDescriptor = this.getAssets().openFd(ringname);
            this.mMediaPlayer = new MediaPlayer();
            this.mMediaPlayer.setDataSource(fileDescriptor.getFileDescriptor(), fileDescriptor.getStartOffset(), fileDescriptor.getLength());
            AudioManager audioManager = (AudioManager)this.getSystemService("audio");
            if (audioManager.getStreamVolume(4) != 0) {
                this.mMediaPlayer.setAudioStreamType(4);
                this.mMediaPlayer.setLooping(true);
                this.mMediaPlayer.prepare();
                this.mMediaPlayer.start();
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void releaseRingtong() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        this.recoverAudiaMode();
    }

    private void recoverAudiaMode() {
        this.mAudioManager.setMode(this.initAudioMode);
    }

    protected void enableHandOffAndSoundOff(final ImageView sound_off, final ImageView hands_off) {
        sound_off.getDrawable().setLevel(2);
        sound_off.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Log.d((String)"aff", (String)"=================sound_off_id================");
                if (sound_off.getDrawable().getLevel() == 2) {
                    BaseActivity.this.session.StopSendLocalAudio(1);
                    sound_off.getDrawable().setLevel(3);
                } else if (sound_off.getDrawable().getLevel() == 3) {
                    BaseActivity.this.session.StartSendLocalAudio(1);
                    sound_off.getDrawable().setLevel(2);
                }
            }
        });
        hands_off.getDrawable().setLevel(2);
        hands_off.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Log.d((String)"aff", (String)"=================hands_off================");
                if (hands_off.getDrawable().getLevel() == 2) {
                    BaseActivity.this.session.SetLoudSpeakerEnable(true);
                    hands_off.getDrawable().setLevel(3);
                } else if (hands_off.getDrawable().getLevel() == 3) {
                    BaseActivity.this.session.SetLoudSpeakerEnable(false);
                    hands_off.getDrawable().setLevel(2);
                }
            }
        });
    }

    protected void setPhoto(final String uri) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Log.i((String)"aff", (String)("======================setPhoto==================" + uri));
                BitmapFactory.Options sDefaultOptions = new BitmapFactory.Options();
                sDefaultOptions.inDither = true;
                sDefaultOptions.inScaled = true;
                sDefaultOptions.inDensity = 160;
                sDefaultOptions.inTargetDensity = BaseActivity.this.getResources().getDisplayMetrics().densityDpi;
                Bitmap bitmap = null;
                try {
                    InputStream inputStream = new URL(uri).openStream();
                    bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)sDefaultOptions);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Message msg = BaseActivity.this.setPhotoHandler.obtainMessage();
                msg.obj = bitmap;
                BaseActivity.this.setPhotoHandler.sendMessage(msg);
            }
        }).start();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.session.StartSendLocalAudio(1);
        this.session.SetLoudSpeakerEnable(false);
        this.session.Terminate();
        Log.d((String)"fff", (String)("==============onDestroy=====================" + this.isVoIPSuccess));
        if (this.isVoIPSuccess) {
            RongIMVoIP.endVoIP(this.appId, this.sessionId, this.mySelfId);
        }
        this.unregisterReceiver(this.rmb);
        this.releaseRingtong();
        this.wakeLock.release();
    }

    public class ReciveMsgBroadCastReciver
    extends BroadcastReceiver {
        public void onReceive(Context contex, Intent intent) {
            RongIMClient.MessageContent mc = (RongIMClient.MessageContent)intent.getParcelableExtra("messageContent");
            Log.d((String)"voip", (String)("==========voip=====\u63a5\u6536\u5230\u4e00\u4e2acom.ccrc.avtest.action.reciveMsg\u7684\u5e7f\u64ad====" + mc));
            if (mc == null && intent.getBooleanExtra("kicked_message", false)) {
                VoIPFinishMessage vfm = new VoIPFinishMessage(BaseActivity.this.peerid);
                vfm.setFinish_state(0);
                BaseActivity.this.sendMsg(vfm);
                BaseActivity.this.finish();
            } else if (mc instanceof VoIPAcceptMessage) {
                ((CallSideActivity)BaseActivity.this).CalledAcceptCall();
            } else if (mc instanceof VoIPFinishMessage) {
                VoIPFinishMessage vfm = (VoIPFinishMessage)mc;
                if (vfm.getFinish_state() == 0) {
                    Toast.makeText((Context)BaseActivity.this, (CharSequence)"\u5bf9\u65b9\u5df2\u7ecf\u6302\u673a\uff01\uff01\uff01", (int)1).show();
                    BaseActivity.this.stopCountTime();
                } else if (vfm.getFinish_state() == 1) {
                    Toast.makeText((Context)BaseActivity.this, (CharSequence)"\u5bf9\u65b9\u62d2\u7edd\u4e86\u4f60\u7684\u8bf7\u6c42\uff01\uff01\uff01", (int)1).show();
                }
                BaseActivity.this.finish();
            }
        }
    }
}

