/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import com.sea_monster.core.resource.ResourceManager;
import com.sea_monster.core.resource.model.Resource;
import io.rong.imlib.FileUtil;
import io.rong.imlib.MessageTag;
import io.rong.imlib.RongIMClient;
import io.rong.message.MessageHandlerContext;
import io.rong.message.VoiceMessage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class VoiceMessageHandler
extends MessageTag.MessageHandler<VoiceMessage> {
    public VoiceMessageHandler(Context context) {
        super(context);
        if (ResourceManager.getInstance() == null) {
            MessageHandlerContext.init(context);
        }
    }

    @Override
    public void afterDecodeMessage(RongIMClient.Message message, VoiceMessage model) {
        File file;
        Uri uri = VoiceMessageHandler.obtainVoiceUri(this.getContext(), message);
        if (!ResourceManager.getInstance().containsInDisk(new Resource(uri)) && !TextUtils.isEmpty((CharSequence)model.getBase64())) {
            byte[] audio = Base64.decode((String)model.getBase64(), (int)2);
            ByteArrayInputStream stream = new ByteArrayInputStream(audio);
            ResourceManager.getInstance().put(new Resource(uri), stream);
        }
        if ((file = ResourceManager.getInstance().getCacheFile(new Resource(uri))) != null && file.exists()) {
            model.setUri(Uri.fromFile((File)file));
        }
        model.setBase64(null);
    }

    @Override
    public boolean beforeEncodeMessage(RongIMClient.Message message, VoiceMessage model) {
        Uri uri = VoiceMessageHandler.obtainVoiceUri(this.getContext(), message);
        byte[] voiceData = FileUtil.getByteFromUri(model.getUri());
        String base64 = Base64.encodeToString((byte[])voiceData, (int)2);
        model.setBase64(base64);
        String path = model.getUri().getPath();
        try {
            FileInputStream inputStream = new FileInputStream(path);
            ResourceManager.getInstance().put(new Resource(uri), inputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        File file = ResourceManager.getInstance().getCacheFile(new Resource(uri));
        if (file != null && file.exists()) {
            model.setUri(Uri.fromFile((File)file));
        }
        return true;
    }

    @Override
    public boolean sendMessage(RongIMClient client, RongIMClient.Message message, VoiceMessage model, RongIMClient.SendMessageCallback callback) {
        return false;
    }

    private static Uri obtainVoiceUri(Context context, RongIMClient.Message message) {
        Uri uri = Uri.parse((String)("rong://" + context.getPackageName())).buildUpon().appendPath("voice").appendPath(String.valueOf(message.getMessageId())).appendPath(message.getSenderUserId()).build();
        return uri;
    }
}

