/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.sea_monster.core.utils.ParcelUtils;
import io.rong.imlib.MessageTag;
import io.rong.imlib.RongIMClient;
import io.rong.message.VoiceMessageHandler;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:VcMsg", flag=3, messageHandler=VoiceMessageHandler.class)
public class VoiceMessage
extends RongIMClient.MessageContent {
    private Uri mUri;
    private int mDuration;
    private String mBase64;
    protected String extra;
    public static final Parcelable.Creator<VoiceMessage> CREATOR = new Parcelable.Creator<VoiceMessage>(){

        public VoiceMessage createFromParcel(Parcel source) {
            return new VoiceMessage(source);
        }

        public VoiceMessage[] newArray(int size) {
            return new VoiceMessage[size];
        }
    };

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public VoiceMessage(Parcel in) {
        this.setExtra(ParcelUtils.readFromParcel(in));
        this.mUri = ParcelUtils.readFromParcel(in, Uri.class);
        this.mDuration = ParcelUtils.readIntFromParcel(in);
        this.setPushContent(ParcelUtils.readFromParcel(in));
    }

    public VoiceMessage(byte[] data) {
        String jsonStr = new String(data);
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has("duration")) {
                this.setDuration(jsonObj.getInt("duration"));
            }
            if (jsonObj.has("content")) {
                this.setBase64(jsonObj.getString("content"));
            }
            if (jsonObj.has("extra")) {
                this.setExtra(jsonObj.getString("extra"));
            }
        }
        catch (JSONException e) {
            Log.e((String)"JSONException", (String)e.getMessage());
        }
    }

    private VoiceMessage(Uri uri, int duration) {
        this.mUri = uri;
        this.mDuration = duration;
    }

    public static VoiceMessage obtain(Uri uri, int duration) {
        return new VoiceMessage(uri, duration);
    }

    public Uri getUri() {
        return this.mUri;
    }

    public void setUri(Uri uri) {
        this.mUri = uri;
    }

    public int getDuration() {
        return this.mDuration;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
    }

    public String getBase64() {
        return this.mBase64;
    }

    public void setBase64(String base64) {
        this.mBase64 = base64;
    }

    @Override
    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("content", (Object)this.mBase64);
            jsonObj.put("duration", this.mDuration);
            if (!TextUtils.isEmpty((CharSequence)this.getExtra())) {
                jsonObj.put("extra", (Object)this.extra);
            }
        }
        catch (JSONException e) {
            Log.e((String)"JSONException", (String)e.getMessage());
        }
        this.mBase64 = null;
        return jsonObj.toString().getBytes();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.extra);
        ParcelUtils.writeToParcel(dest, this.mUri);
        ParcelUtils.writeToParcel(dest, this.mDuration);
        ParcelUtils.writeToParcel(dest, this.getPushContent());
    }
}

