/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.sea_monster.core.utils.ParcelUtils;
import io.rong.imlib.MessageTag;
import io.rong.imlib.RongIMClient;
import io.rong.message.utils.RLog;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:TxtMsg", flag=3)
public class TextMessage
extends RongIMClient.MessageContent {
    private String content;
    private String extra;
    public static final Parcelable.Creator<TextMessage> CREATOR = new Parcelable.Creator<TextMessage>(){

        public TextMessage createFromParcel(Parcel source) {
            return new TextMessage(source);
        }

        public TextMessage[] newArray(int size) {
            return new TextMessage[size];
        }
    };

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    @Override
    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("content", (Object)this.getExpression(this.getContent()));
            if (!TextUtils.isEmpty((CharSequence)this.getExtra())) {
                jsonObj.put("extra", (Object)this.getExtra());
            }
        }
        catch (JSONException e) {
            RLog.e("JSONException", e.getMessage());
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getExpression(String content) {
        Pattern pattern = Pattern.compile("\\[/u([0-9A-Fa-f]+)\\]");
        Matcher matcher = pattern.matcher(content);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int inthex = Integer.parseInt(matcher.group(1), 16);
            matcher.appendReplacement(sb, String.valueOf(Character.toChars(inthex)));
        }
        matcher.appendTail(sb);
        RLog.d("getExpression--", sb.toString());
        return sb.toString();
    }

    protected TextMessage() {
    }

    public static TextMessage obtain(String text) {
        TextMessage model = new TextMessage();
        model.setContent(text);
        return model;
    }

    public TextMessage(byte[] data) {
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            // empty catch block
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has("content")) {
                this.setContent(jsonObj.getString("content"));
            }
            if (jsonObj.has("extra")) {
                this.setExtra(jsonObj.getString("extra"));
            }
        }
        catch (JSONException e) {
            RLog.e("JSONException", e.getMessage());
        }
    }

    public void setContent(String content) {
        this.content = content;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.getExtra());
        ParcelUtils.writeToParcel(dest, this.content);
        ParcelUtils.writeToParcel(dest, this.pushContent);
    }

    public TextMessage(Parcel in) {
        this.setExtra(ParcelUtils.readFromParcel(in));
        this.setContent(ParcelUtils.readFromParcel(in));
        this.setPushContent(ParcelUtils.readFromParcel(in));
    }

    public TextMessage(String content) {
        this.setContent(content);
    }

    public String getContent() {
        return this.content;
    }
}

