/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.sea_monster.core.utils.ParcelUtils;
import io.rong.imlib.MessageTag;
import io.rong.imlib.RongIMClient;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:ImgTextMsg", flag=3)
public class RichContentMessage
extends RongIMClient.MessageContent
implements Parcelable {
    private String title;
    private String content;
    private String url;
    private String extra = "";
    public static final Parcelable.Creator<RichContentMessage> CREATOR = new Parcelable.Creator<RichContentMessage>(){

        public RichContentMessage createFromParcel(Parcel source) {
            return new RichContentMessage(source);
        }

        public RichContentMessage[] newArray(int size) {
            return new RichContentMessage[size];
        }
    };

    public RichContentMessage(String title, String content, String imageUrl) {
        if (TextUtils.isEmpty((CharSequence)title) || TextUtils.isEmpty((CharSequence)content) || TextUtils.isEmpty((CharSequence)imageUrl)) {
            throw new IllegalArgumentException();
        }
        this.title = title;
        this.content = content;
        this.url = imageUrl;
    }

    public static RichContentMessage obtain(String title, String content, String imageUrl) {
        return new RichContentMessage(title, content, imageUrl);
    }

    protected RichContentMessage(Parcel in) {
        this.title = ParcelUtils.readFromParcel(in);
        this.content = ParcelUtils.readFromParcel(in);
        this.url = ParcelUtils.readFromParcel(in);
        this.extra = ParcelUtils.readFromParcel(in);
    }

    public RichContentMessage() {
    }

    public RichContentMessage(byte[] data) {
        String jsonStr = new String(data);
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            this.title = jsonObj.getString("title");
            this.content = jsonObj.getString("content");
            this.url = jsonObj.getString("imageUri");
            this.extra = jsonObj.getString("extra");
        }
        catch (JSONException e) {
            Log.e((String)"JSONException", (String)e.getMessage());
        }
    }

    @Override
    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("title", (Object)this.getExpression(this.getTitle()));
            jsonObj.put("content", (Object)this.getExpression(this.getContent()));
            jsonObj.put("imageUri", (Object)this.getUrl());
            jsonObj.put("extra", (Object)this.getExtra());
        }
        catch (JSONException e) {
            Log.e((String)"JSONException", (String)e.getMessage());
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.title);
        ParcelUtils.writeToParcel(dest, this.content);
        ParcelUtils.writeToParcel(dest, this.url);
        ParcelUtils.writeToParcel(dest, this.extra);
    }

    private String getExpression(String content) {
        Pattern pattern = Pattern.compile("\\[/u([0-9A-Fa-f]+)\\]");
        Matcher matcher = pattern.matcher(content);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, this.toExpressionChar(matcher.group(1)));
        }
        matcher.appendTail(sb);
        Log.d((String)"getExpression--", (String)sb.toString());
        return sb.toString();
    }

    private String toExpressionChar(String expChar) {
        int inthex = Integer.parseInt(expChar, 16);
        return String.valueOf(Character.toChars(inthex));
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }
}

