/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.content.Context;
import android.content.ContextWrapper;
import android.os.Environment;
import com.sea_monster.core.common.DiscardOldestPolicy;
import com.sea_monster.core.network.DefaultHttpHandler;
import com.sea_monster.core.resource.ResourceManager;
import com.sea_monster.core.resource.cache.ResourceCacheWrapper;
import com.sea_monster.core.resource.compress.ResourceCompressHandler;
import com.sea_monster.core.resource.io.FileSysHandler;
import com.sea_monster.core.resource.io.ResourceRemoteWrapper;
import com.sea_monster.core.utils.FileUtils;
import java.io.File;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import uk.co.senab.bitmapcache.BitmapLruCache;

public class MessageHandlerContext
extends ContextWrapper {
    private static MessageHandlerContext sS;

    public static MessageHandlerContext getInstance() {
        return sS;
    }

    private MessageHandlerContext(Context base) {
        super(base);
        PriorityBlockingQueue<Runnable> mWorkQueue = new PriorityBlockingQueue<Runnable>(25);
        ThreadFactory mThreadFactory = new ThreadFactory(){
            private final AtomicInteger mCount = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "ConnectTask #" + this.mCount.getAndIncrement());
            }
        };
        ThreadPoolExecutor executor = new ThreadPoolExecutor(2, 3, 1L, TimeUnit.SECONDS, mWorkQueue, mThreadFactory);
        executor.setRejectedExecutionHandler(new DiscardOldestPolicy());
        FileSysHandler fileSysHandler = new FileSysHandler(executor, this.getResourceDir((Context)this), "file", "rong");
        DefaultHttpHandler httpHandler = new DefaultHttpHandler((Context)this, executor);
        ResourceRemoteWrapper remoteWrapper = new ResourceRemoteWrapper((Context)this, fileSysHandler, httpHandler);
        File cacheFile = new File(this.getResourceDir((Context)this), "cache");
        if (!cacheFile.exists()) {
            FileUtils.createDirectory(cacheFile, true);
        }
        BitmapLruCache cache = new BitmapLruCache.Builder((Context)this).setDiskCacheEnabled(true).setDiskCacheLocation(cacheFile).setMemoryCacheMaxSize(6164480).build();
        ResourceCompressHandler compressHandler = new ResourceCompressHandler((Context)this, fileSysHandler);
        ResourceCacheWrapper cacheWrapper = new ResourceCacheWrapper((Context)this, cache, fileSysHandler, compressHandler);
        ResourceManager.init((Context)this, remoteWrapper, cacheWrapper);
    }

    public static void init(Context context) {
        sS = new MessageHandlerContext(context);
    }

    private final File getResourceDir(Context context) {
        File root = null;
        if (Environment.getExternalStorageState().equals("mounted")) {
            root = context.getExternalFilesDir("RongCloud");
        }
        if (root == null) {
            root = new File(context.getFilesDir(), "RongCloud");
        }
        if (!root.exists()) {
            root.mkdirs();
        }
        return root;
    }
}

