/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.sea_monster.core.exception.BaseException;
import com.sea_monster.core.network.AbstractHttpRequest;
import com.sea_monster.core.network.StoreStatusCallback;
import com.sea_monster.core.resource.ResourceManager;
import com.sea_monster.core.resource.model.Resource;
import com.sea_monster.core.resource.model.StoreStatus;
import io.rong.imlib.MessageTag;
import io.rong.imlib.RongIMClient;
import io.rong.message.LocationMessage;
import io.rong.message.MessageHandlerContext;
import io.rong.message.utils.BitmapUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;

public class LocationMessageHandler
extends MessageTag.MessageHandler<LocationMessage> {
    public LocationMessageHandler(Context context) {
        super(context);
        if (ResourceManager.getInstance() == null) {
            MessageHandlerContext.init(context);
        }
    }

    @Override
    public void afterDecodeMessage(RongIMClient.Message message, LocationMessage content) {
        Uri uri = LocationMessageHandler.obtainLocationUri(this.getContext(), message);
        if (content != null) {
            if (!ResourceManager.getInstance().containsInDisk(new Resource(uri)) && !TextUtils.isEmpty((CharSequence)content.getBase64())) {
                if (content.getBase64().startsWith("file") || content.getBase64().startsWith("http")) {
                    content.setImgUri(Uri.parse((String)content.getBase64()));
                } else {
                    byte[] audio = Base64.decode((String)content.getBase64(), (int)2);
                    ByteArrayInputStream stream = new ByteArrayInputStream(audio);
                    ResourceManager.getInstance().put(new Resource(uri), stream);
                }
            }
            if (content.getImgUri() == null) {
                content.setImgUri(ResourceManager.getInstance().getFileUri(new Resource(uri)));
            }
            content.setBase64(null);
        }
    }

    @Override
    public boolean beforeEncodeMessage(RongIMClient.Message message, LocationMessage content) {
        if (content.getImgUri().getScheme().equals("file")) {
            try {
                File file;
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeFile((String)content.getImgUri().getPath(), (BitmapFactory.Options)options);
                Uri uri = LocationMessageHandler.obtainLocationUri(this.getContext(), message);
                Bitmap bitmap = BitmapUtil.getResizedBitmap(this.getContext(), content.getImgUri(), 240, 240);
                if (bitmap != null) {
                    String base64 = BitmapUtil.getBase64FromBitmap(bitmap);
                    Log.d((String)"base64Str", (String)("" + base64.length()));
                    content.setBase64(base64);
                    ResourceManager.getInstance().put(new Resource(uri), bitmap);
                }
                if ((file = ResourceManager.getInstance().getCacheFile(new Resource(uri))) != null && file.exists()) {
                    content.setImgUri(Uri.fromFile((File)file));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean sendMessage(final RongIMClient client, final RongIMClient.Message message, final LocationMessage messageContent, final RongIMClient.SendMessageCallback callback) {
        if (messageContent.getImgUri().getScheme().equals("file")) {
            return false;
        }
        if (ResourceManager.getInstance().containsInDisk(new Resource(messageContent.getImgUri()))) {
            messageContent.setImgUri(ResourceManager.getInstance().getFileUri(new Resource(messageContent.getImgUri())));
            return false;
        }
        try {
            ResourceManager.getInstance().requestResource(new Resource(messageContent.getImgUri()), new StoreStatusCallback(){

                @Override
                public void onComplete(AbstractHttpRequest<File> fileAbstractHttpRequest, File file) {
                    messageContent.setImgUri(Uri.fromFile((File)file));
                    callback.onSuccess(message.getMessageId());
                    LocationMessageHandler.this.flush();
                }

                @Override
                public void onFailure(AbstractHttpRequest<File> fileAbstractHttpRequest, BaseException e) {
                    client.setMessageSentStatus(message.getMessageId(), RongIMClient.SentStatus.FAILED);
                    callback.onError(message.getMessageId(), RongIMClient.SendMessageCallback.ErrorCode.HANDLER_EXP);
                }

                @Override
                public void statusCallback(StoreStatus storeStatus) {
                    callback.onProgress(message.getMessageId(), storeStatus.getPercent());
                }
            });
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static Uri obtainLocationUri(Context context, RongIMClient.Message message) {
        Uri uri = Uri.parse((String)("rong://" + context.getPackageName())).buildUpon().appendPath("location").appendPath(String.valueOf(message.getMessageId())).appendPath(message.getSenderUserId()).build();
        return uri;
    }
}

