/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.sea_monster.core.utils.ParcelUtils;
import io.rong.imlib.MessageTag;
import io.rong.imlib.RongIMClient;
import io.rong.message.utils.RLog;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:InfoNtf", flag=1)
public class InformationNotificationMessage
extends RongIMClient.MessageContent {
    private String message;
    protected String extra;
    public static final Parcelable.Creator<InformationNotificationMessage> CREATOR = new Parcelable.Creator<InformationNotificationMessage>(){

        public InformationNotificationMessage createFromParcel(Parcel source) {
            return new InformationNotificationMessage(source);
        }

        public InformationNotificationMessage[] newArray(int size) {
            return new InformationNotificationMessage[size];
        }
    };

    @Override
    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("message", (Object)this.getMessage());
            if (!TextUtils.isEmpty((CharSequence)this.getExtra())) {
                jsonObj.put("extra", (Object)this.getExtra());
            }
        }
        catch (JSONException e) {
            RLog.e("JSONException", e.getMessage());
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected InformationNotificationMessage() {
    }

    public static InformationNotificationMessage obtain(String message) {
        InformationNotificationMessage model = new InformationNotificationMessage();
        model.setMessage(message);
        return model;
    }

    public InformationNotificationMessage(byte[] data) {
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            // empty catch block
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            this.setMessage(jsonObj.getString("message"));
            if (jsonObj.has("extra")) {
                this.setExtra(jsonObj.getString("extra"));
            }
        }
        catch (JSONException e) {
            RLog.e("JSONException", e.getMessage());
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.message);
        ParcelUtils.writeToParcel(dest, this.getExtra());
    }

    public InformationNotificationMessage(Parcel in) {
        this.setMessage(ParcelUtils.readFromParcel(in));
        this.setExtra(ParcelUtils.readFromParcel(in));
    }

    public InformationNotificationMessage(String message) {
        this.setMessage(message);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }
}

