/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.sea_monster.core.resource.ResourceManager;
import com.sea_monster.core.resource.model.Resource;
import io.rong.imlib.MessageTag;
import io.rong.imlib.RongIMClient;
import io.rong.message.ImageMessage;
import io.rong.message.MessageHandlerContext;
import io.rong.message.utils.BitmapUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class ImageMessageHandler
extends MessageTag.MessageHandler<ImageMessage> {
    public ImageMessageHandler(Context context) {
        super(context);
        if (ResourceManager.getInstance() == null) {
            MessageHandlerContext.init(context);
        }
    }

    @Override
    public void afterDecodeMessage(RongIMClient.Message message, ImageMessage model) {
        if (message != null) {
            File file;
            Bitmap bitmap;
            Uri uri = ImageMessageHandler.obtainThumImageUri(this.getContext(), message);
            if (!ResourceManager.getInstance().containsInCache(new Resource(uri)) && !TextUtils.isEmpty((CharSequence)model.getBase64()) && (bitmap = BitmapUtil.getBitmapFromBase64(model.getBase64())) != null) {
                ResourceManager.getInstance().put(new Resource(uri), bitmap);
            }
            if (model.getRemoteUri() != null && model.getRemoteUri().getScheme().equals("file")) {
                model.setThumUri(model.getRemoteUri());
                try {
                    File file2;
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inJustDecodeBounds = true;
                    BitmapFactory.decodeFile((String)model.getThumUri().getPath(), (BitmapFactory.Options)options);
                    Bitmap bitmap2 = BitmapUtil.getResizedBitmap(this.getContext(), model.getThumUri(), 240, 240);
                    if (bitmap2 != null) {
                        ResourceManager.getInstance().put(new Resource(uri), bitmap2);
                    }
                    if ((file2 = ResourceManager.getInstance().getCacheFile(new Resource(uri))) != null && file2.exists()) {
                        model.setThumUri(Uri.fromFile((File)file2));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if ((file = ResourceManager.getInstance().getCacheFile(new Resource(uri))) != null && file.exists()) {
                model.setThumUri(Uri.fromFile((File)file));
            } else {
                Log.e((String)"ImageMessageHandler", (String)"Thumb file is not exit!");
            }
        }
        model.setBase64(null);
    }

    @Override
    public boolean beforeEncodeMessage(RongIMClient.Message message, ImageMessage model) {
        if (model.getThumUri() != null && model.getThumUri().getScheme().equals("file")) {
            try {
                File file;
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeFile((String)model.getThumUri().getPath(), (BitmapFactory.Options)options);
                Uri uri = ImageMessageHandler.obtainThumImageUri(this.getContext(), message);
                Bitmap bitmap = BitmapUtil.getResizedBitmap(this.getContext(), model.getThumUri(), 240, 240);
                if (bitmap != null) {
                    String base64 = BitmapUtil.getBase64FromBitmap(bitmap);
                    model.setBase64(base64);
                    ResourceManager.getInstance().put(new Resource(uri), bitmap);
                }
                if ((file = ResourceManager.getInstance().getCacheFile(new Resource(uri))) != null && file.exists()) {
                    model.setThumUri(Uri.fromFile((File)file));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    @Override
    public boolean sendMessage(final RongIMClient client, final RongIMClient.Message message, final ImageMessage model, final RongIMClient.SendMessageCallback callback) {
        if (model.getLocalUri() == null && model.getRemoteUri() != null && model.getRemoteUri().getScheme().equals("file")) {
            model.setLocalUri(model.getRemoteUri());
        }
        if (model.getLocalUri() != null && !model.getLocalUri().getScheme().equals("file") && model.getRemoteUri() == null) {
            model.setUpLoadExp(true);
            return false;
        }
        try {
            FileInputStream stream = new FileInputStream(model.getLocalUri().getPath());
            client.uploadMedia(message.getConversationType(), message.getTargetId(), stream, new RongIMClient.UploadMediaCallback(){

                @Override
                public void onProgress(int progress) {
                    callback.onProgress(message.getMessageId(), progress);
                }

                @Override
                public void onSuccess(String uri) {
                    model.setRemoteUri(Uri.parse((String)uri));
                    ImageMessageHandler.this.flush();
                }

                @Override
                public void onError(RongIMClient.UploadMediaCallback.ErrorCode errorCode) {
                    model.setUpLoadExp(true);
                    callback.onError(message.getMessageId(), RongIMClient.SendMessageCallback.ErrorCode.HANDLER_EXP);
                    client.setMessageSentStatus(message.getMessageId(), RongIMClient.SentStatus.FAILED);
                }
            });
        }
        catch (IOException e) {
            model.setUpLoadExp(true);
            callback.onError(message.getMessageId(), RongIMClient.SendMessageCallback.ErrorCode.HANDLER_EXP);
        }
        return true;
    }

    private static Uri obtainThumImageUri(Context context, RongIMClient.Message message) {
        Uri uri = Uri.parse((String)("rong://" + context.getPackageName())).buildUpon().appendPath("image").appendPath("thum").appendPath(String.valueOf(message.getMessageId())).appendPath(message.getSenderUserId()).build();
        return uri;
    }
}

