/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.sea_monster.core.utils.ParcelUtils;
import io.rong.imlib.MessageTag;
import io.rong.imlib.RongIMClient;
import io.rong.message.ImageMessageHandler;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:ImgMsg", flag=3, messageHandler=ImageMessageHandler.class)
public class ImageMessage
extends RongIMClient.MessageContent {
    Uri mThumUri;
    Uri mLocalUri;
    Uri mRemoteUri;
    private boolean mUpLoadExp = false;
    String mBase64;
    protected String extra;
    public static final Parcelable.Creator<ImageMessage> CREATOR = new Parcelable.Creator<ImageMessage>(){

        public ImageMessage createFromParcel(Parcel source) {
            return new ImageMessage(source);
        }

        public ImageMessage[] newArray(int size) {
            return new ImageMessage[size];
        }
    };

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public ImageMessage(byte[] data) {
        String jsonStr = new String(data);
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has("imageUri")) {
                this.setRemoteUri(Uri.parse((String)jsonObj.getString("imageUri")));
                if (this.getRemoteUri().getScheme().equals("file")) {
                    this.setLocalUri(this.getRemoteUri());
                    if (jsonObj.has("thumbUri")) {
                        this.setThumUri(Uri.parse((String)jsonObj.getString("imageUri")));
                    }
                }
            }
            if (jsonObj.has("content")) {
                this.setBase64(jsonObj.getString("content"));
            }
            if (jsonObj.has("extra")) {
                this.setExtra(jsonObj.getString("extra"));
            }
            if (jsonObj.has("exp")) {
                this.setUpLoadExp(true);
            }
        }
        catch (JSONException e) {
            Log.e((String)"JSONException", (String)e.getMessage());
        }
    }

    private ImageMessage() {
    }

    private ImageMessage(Uri thumUri, Uri localUri) {
        this.mThumUri = thumUri;
        this.mLocalUri = localUri;
    }

    public static ImageMessage obtain(Uri thumUri, Uri localUri) {
        return new ImageMessage(thumUri, localUri);
    }

    public static ImageMessage obtain() {
        return new ImageMessage();
    }

    public Uri getThumUri() {
        return this.mThumUri;
    }

    public void setThumUri(Uri thumUri) {
        this.mThumUri = thumUri;
    }

    public Uri getLocalUri() {
        return this.mLocalUri;
    }

    public void setLocalUri(Uri localUri) {
        this.mLocalUri = localUri;
    }

    public Uri getRemoteUri() {
        return this.mRemoteUri;
    }

    public void setRemoteUri(Uri remoteUri) {
        this.mRemoteUri = remoteUri;
    }

    public void setBase64(String base64) {
        this.mBase64 = base64;
    }

    public String getBase64() {
        return this.mBase64;
    }

    public boolean isUpLoadExp() {
        return this.mUpLoadExp;
    }

    public void setUpLoadExp(boolean upLoadExp) {
        this.mUpLoadExp = upLoadExp;
    }

    @Override
    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            if (!TextUtils.isEmpty((CharSequence)this.mBase64)) {
                jsonObj.put("content", (Object)this.mBase64);
            } else {
                Log.d((String)"ImageMessage", (String)"base64 is null");
            }
            if (this.mRemoteUri != null) {
                jsonObj.put("imageUri", (Object)this.mRemoteUri.toString());
            } else if (this.getLocalUri() != null) {
                jsonObj.put("imageUri", (Object)this.getLocalUri().toString());
                if (this.getThumUri() != null) {
                    jsonObj.put("thumbUri", (Object)this.getThumUri().toString());
                }
            }
            if (this.mUpLoadExp) {
                jsonObj.put("exp", true);
            }
            if (!TextUtils.isEmpty((CharSequence)this.getExtra())) {
                jsonObj.put("extra", (Object)this.getExtra());
            }
        }
        catch (JSONException e) {
            Log.e((String)"JSONException", (String)e.getMessage());
        }
        this.mBase64 = null;
        return jsonObj.toString().getBytes();
    }

    public int describeContents() {
        return 0;
    }

    public ImageMessage(Parcel in) {
        this.setExtra(ParcelUtils.readFromParcel(in));
        this.mLocalUri = ParcelUtils.readFromParcel(in, Uri.class);
        this.mRemoteUri = ParcelUtils.readFromParcel(in, Uri.class);
        this.mThumUri = ParcelUtils.readFromParcel(in, Uri.class);
        this.setPushContent(ParcelUtils.readFromParcel(in));
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.getExtra());
        ParcelUtils.writeToParcel(dest, this.mLocalUri);
        ParcelUtils.writeToParcel(dest, this.mRemoteUri);
        ParcelUtils.writeToParcel(dest, this.mThumUri);
        ParcelUtils.writeToParcel(dest, this.getPushContent());
    }
}

