/*
 * Decompiled with CFR 0.152.
 */
package io.rong.message;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.sea_monster.core.utils.ParcelUtils;
import io.rong.imlib.MessageTag;
import io.rong.imlib.RongIMClient;
import io.rong.message.utils.RLog;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:GrpNtf", flag=1)
class GroupNotificationMessage
extends RongIMClient.MessageContent {
    public static final String GroupOperationAdd = "Add";
    public static final String GroupOperationQuit = "Quit";
    public static final String GroupOperationKicked = "Kicked";
    public static final String GroupOperationRename = "Rename";
    public static final String GroupOperationBulletin = "Bulletin";
    private String operatorUserId;
    private String operation;
    private String data;
    private String message;
    private String extra;
    public static final Parcelable.Creator<GroupNotificationMessage> CREATOR = new Parcelable.Creator<GroupNotificationMessage>(){

        public GroupNotificationMessage createFromParcel(Parcel source) {
            return new GroupNotificationMessage(source);
        }

        public GroupNotificationMessage[] newArray(int size) {
            return new GroupNotificationMessage[size];
        }
    };

    public String getOperatorUserId() {
        return this.operatorUserId;
    }

    public void setOperatorUserId(String operatorUserId) {
        this.operatorUserId = operatorUserId;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public GroupNotificationMessage(Parcel in) {
        this.operatorUserId = ParcelUtils.readFromParcel(in);
        this.operation = ParcelUtils.readFromParcel(in);
        this.data = ParcelUtils.readFromParcel(in);
        this.message = ParcelUtils.readFromParcel(in);
        this.extra = ParcelUtils.readFromParcel(in);
    }

    public static GroupNotificationMessage obtain(String operatorUserId, String operation, String data, String message) {
        GroupNotificationMessage obj = new GroupNotificationMessage();
        obj.operatorUserId = operatorUserId;
        obj.operation = operation;
        obj.data = data;
        obj.message = message;
        return obj;
    }

    private GroupNotificationMessage() {
    }

    @Override
    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("operatorUserId", (Object)this.operatorUserId);
            jsonObj.put("operation", (Object)this.operation);
            if (!TextUtils.isEmpty((CharSequence)this.data)) {
                jsonObj.put("data", (Object)this.data);
            }
            if (!TextUtils.isEmpty((CharSequence)this.message)) {
                jsonObj.put("message", (Object)this.message);
            }
            if (!TextUtils.isEmpty((CharSequence)this.getExtra())) {
                jsonObj.put("extra", (Object)this.getExtra());
            }
        }
        catch (JSONException e) {
            RLog.e("JSONException", e.getMessage());
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public GroupNotificationMessage(byte[] data) {
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            // empty catch block
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            this.setOperatorUserId(jsonObj.optString("operatorUserId"));
            this.setOperation(jsonObj.optString("operation"));
            this.setData(jsonObj.optString("data"));
            this.setMessage(jsonObj.optString("message"));
            this.setExtra(jsonObj.optString("extra"));
        }
        catch (JSONException e) {
            RLog.e("JSONException", e.getMessage());
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.operatorUserId);
        ParcelUtils.writeToParcel(dest, this.operation);
        ParcelUtils.writeToParcel(dest, this.data);
        ParcelUtils.writeToParcel(dest, this.message);
        ParcelUtils.writeToParcel(dest, this.extra);
    }

    public int describeContents() {
        return 0;
    }
}

