/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.push;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.sea_monster.core.exception.BaseException;
import com.sea_monster.core.network.AbstractHttpRequest;
import com.sea_monster.core.network.parser.IEntityParser;
import de.greenrobot.dao.query.WhereCondition;
import io.rong.database.Version;
import io.rong.database.VersionDao;
import io.rong.imlib.common.JsonEntityParser;
import io.rong.imlib.common.RLog;
import io.rong.imlib.common.RongVersionDatabase;
import io.rong.imlib.common.Utils;
import io.rong.imlib.model.AppVersion;
import io.rong.imlib.notification.RongNotificationManager;
import io.rong.imlib.push.PushClient;
import io.rong.imlib.push.PushContext;
import io.rong.imlib.push.PushProtocalStack;
import io.rong.imlib.push.PushReceiver;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.json.JSONObject;

public class PushService
extends Service {
    private static final String TAG = "PushService";
    private PushHandler mPushHandler;
    private Map<String, Integer> appIdNotificationIdMapping;
    private volatile Looper mServiceLooper;
    private volatile ServiceHandler mServiceHandler;

    public void onStart(Intent intent, int startId) {
        Message msg = this.mServiceHandler.obtainMessage();
        msg.arg1 = startId;
        msg.obj = intent;
        this.mServiceHandler.sendMessage(msg);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.onStart(intent, startId);
        return 3;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    protected void onHandleIntent(Intent intent) {
        if (intent == null || intent.getAction() == null) {
            return;
        }
        if (intent.getAction().equals("io.rong.push.Connect")) {
            if (PushContext.getInstance().getRunningPushServiceVersion() == null) {
                RLog.i((Object)this, "CONNECT_CHECK", "getRunningPushServiceVersion null");
                this.mPushHandler.connect(intent);
            } else if (PushContext.getInstance().getRunningPushServiceVersion().getPushVersionCode() < PushContext.getInstance().getCurrentVersion().getPushVersionCode()) {
                RLog.i((Object)this, "CONNECT_CHECK", PushContext.getInstance().getCurrentVersion().getPushVersionCode() + ":" + PushContext.getInstance().getRunningPushServiceVersion().getPushVersionCode());
                this.mPushHandler.connect(intent);
            } else {
                PushReceiver.completeWakefulIntent((Intent)intent);
            }
        } else if (intent.getAction().equals("io.rong.push.HeartBeat")) {
            this.mPushHandler.heartbeat(intent);
        } else if (intent.getAction().equals("io.rong.push.Disconnect")) {
            this.mPushHandler.disConnect(intent);
        }
    }

    public void onCreate() {
        super.onCreate();
        RLog.i(PushService.class, TAG, "PushService OnCreate");
        Log.i((String)TAG, (String)"PushService OnCreate");
        this.mPushHandler = new PushHandler();
        if (PushContext.getInstance() == null) {
            RongVersionDatabase.init((Context)this);
            RongNotificationManager.init((Context)this);
            PushContext.init((Context)this);
        }
        this.appIdNotificationIdMapping = new HashMap<String, Integer>();
        HandlerThread thread = new HandlerThread("IntentService[PushService]");
        thread.start();
        this.mServiceLooper = thread.getLooper();
        this.mServiceHandler = new ServiceHandler(this.mServiceLooper);
    }

    public void onDestroy() {
        RLog.d((Object)this, TAG, " !!!!!!! Service is destroyed!!!!!");
        if (this.mPushHandler != null) {
            this.mPushHandler.disConnect(null);
        }
        this.mServiceLooper.quit();
        PushContext.getInstance().cancelHeartbeat();
        super.onDestroy();
    }

    private final class PushHandler {
        boolean isClientConnected = false;
        PushClient pushClient;

        private PushHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connect(Intent intent) {
            Log.i((String)"PushHandler", (String)("ConnectToServer,isClientConnected = " + this.isClientConnected));
            Class<PushHandler> clazz = PushHandler.class;
            synchronized (PushHandler.class) {
                if (this.isClientConnected) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                try {
                    StringBuilder pushAddress = new StringBuilder();
                    String deviceId = Utils.getDeviceId((Context)PushService.this);
                    ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                    params.add(new BasicNameValuePair("deviceId", deviceId));
                    JSONObject object = PushContext.getInstance().getHttpHandler().executeRequestSync(new AbstractHttpRequest<JSONObject>(2, URI.create("http://nav.cn.rong.io/navipush.json"), params, (IEntityParser)new JsonEntityParser()){

                        @Override
                        public void onComplete(JSONObject o) {
                        }

                        @Override
                        public void onFailure(BaseException e) {
                        }
                    });
                    String val = object.optString("server");
                    RLog.i(this, "Push_IP", val);
                    pushAddress.append(val);
                    if (TextUtils.isEmpty((CharSequence)pushAddress)) {
                        RLog.e(this, "PushConnect", "Address error");
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    String[] address = pushAddress.toString().split(":");
                    this.pushClient = new PushClient(deviceId, "1", "", new PushClientListener(), null);
                    this.pushClient.connect(address[0], Integer.parseInt(address[1]), new ClientConnectCallback());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.pushClient = null;
                    this.isClientConnected = false;
                    PushContext.getInstance().startNextHeartbeat(180000L);
                }
                PushReceiver.completeWakefulIntent((Intent)intent);
                return;
            }
        }

        public void disConnect(Intent intent) {
            if (this.pushClient != null) {
                this.pushClient.disconnectByNormal();
            }
            if (intent != null) {
                PushReceiver.completeWakefulIntent((Intent)intent);
            }
        }

        public boolean isClientConnected() {
            return this.isClientConnected;
        }

        public void heartbeat(Intent intent) {
            if (PushContext.getInstance().validateNeedSyncVersion()) {
                PushContext.getInstance().syncVersion();
            }
            if (!PushContext.getInstance().isNewestVersion()) {
                PushContext.getInstance().cancelHeartbeat();
                AppVersion version = PushContext.getInstance().getNewestVersion();
                PushContext.getInstance().sendConnectCommand((Context)PushService.this, version.getAppId());
                this.disConnect(intent);
                PushService.this.stopSelf();
                PushReceiver.completeWakefulIntent((Intent)intent);
                return;
            }
            if (this.pushClient != null && this.isClientConnected) {
                try {
                    this.pushClient.ping();
                }
                catch (IOException e) {
                    RLog.e(this, "Heartbeat", e.getMessage(), e);
                    this.pushClient.disconnectByNormal();
                    this.pushClient = null;
                    this.isClientConnected = false;
                    this.connect(intent);
                    e.printStackTrace();
                }
            } else {
                this.connect(intent);
                return;
            }
            PushContext.getInstance().startNextHeartbeat(180000L);
            PushReceiver.completeWakefulIntent((Intent)intent);
        }

        private Bundle parsePushMsgFromJson(String jstr) throws JSONException {
            Bundle bundle = new Bundle();
            JSONObject json = new JSONObject(jstr);
            Log.i((String)PushService.TAG, (String)"parsePushMsgFromJson");
            bundle.putString("objectName", json.getString("objectName"));
            bundle.putString("appId", json.getString("appId"));
            bundle.putString("fromUserId", json.getString("fromUserId"));
            bundle.putString("fromUserName", json.getString("fromUserName"));
            bundle.putString("title", json.getString("title"));
            bundle.putString("content", json.getString("content"));
            bundle.putString("channelType", json.getString("channelType"));
            bundle.putString("channelId", json.getString("channelId"));
            bundle.putString("channelName", json.getString("channelName"));
            return bundle;
        }

        private class PushClientListener
        implements PushClient.ClientListener {
            private PushClientListener() {
            }

            @Override
            public void messageArrived(PushProtocalStack.PublishMessage msg) {
                Bundle bundle = null;
                Intent intent = new Intent();
                if (msg == null || msg.getDataAsString() == null) {
                    RLog.i((Object)PushService.this, "Received", "the message received from server is null!!!");
                    return;
                }
                RLog.i((Object)PushService.this, "Received", msg.getDataAsString());
                try {
                    bundle = PushHandler.this.parsePushMsgFromJson(msg.getDataAsString());
                }
                catch (JSONException e) {
                    System.err.println("Error json string!");
                    e.printStackTrace();
                    return;
                }
                String appId = bundle.getString("appId");
                Version version = (Version)RongVersionDatabase.getVersionDao().queryBuilder().where(VersionDao.Properties.AppKey.eq(appId), new WhereCondition[0]).limit(1).unique();
                if (version == null) {
                    return;
                }
                Log.i((String)PushService.TAG, (String)("the package name with the appId is " + version.getAppId()));
                try {
                    PushService.this.getPackageManager().getPackageInfo(version.getAppId(), 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    e.printStackTrace();
                    RongVersionDatabase.getVersionDao().delete(version);
                    return;
                }
                intent.setAction("io.rong.push.message");
                intent.setPackage(version.getAppId());
                intent.putExtras(bundle);
                PushService.this.sendBroadcast(intent);
            }
        }

        private class ClientConnectCallback
        implements PushClient.ConnectStatusCallback {
            private ClientConnectCallback() {
            }

            @Override
            public void onConnected(PushProtocalStack.ConnAckMessage msg) throws IOException {
                Log.i((String)PushService.TAG, (String)("The client connect status is:" + (Object)((Object)msg.getType())));
                if (msg.getType() == PushProtocalStack.Message.Type.CONNACK) {
                    if (msg.getStatus() != PushProtocalStack.ConnAckMessage.ConnectionStatus.ACCEPTED) {
                        throw new RuntimeException("Connect to server failure!! Error code :" + (Object)((Object)msg.getStatus()));
                    }
                    PushHandler.this.isClientConnected = true;
                    RLog.i((Object)PushService.this, "Connect", "Client connect successfully.So start the heart beat.");
                    PushContext.getInstance().startNextHeartbeat(180000L);
                }
            }

            @Override
            public void onDisconnected(IOException e) {
                RLog.e((Object)PushService.this, "ConnectStatus", e.toString());
                if (!PushContext.getInstance().hasNetworkInfo()) {
                    PushContext.getInstance().cancelHeartbeat();
                }
                PushHandler.this.pushClient = null;
                PushHandler.this.isClientConnected = false;
            }
        }
    }

    private final class ServiceHandler
    extends Handler {
        public ServiceHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            PushService.this.onHandleIntent((Intent)msg.obj);
        }
    }
}

