/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.push;

import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.util.Log;
import io.rong.imlib.common.RLog;
import io.rong.imlib.model.AppVersion;
import io.rong.imlib.push.CommandService;
import io.rong.imlib.push.PushContext;
import io.rong.imlib.push.PushService;

public class PushReceiver
extends WakefulBroadcastReceiver {
    private static final String TAG = "PushReceiver";
    private static final int STATUS_WIFI = 2;
    private static final int STATUS_MOBILE = 1;
    private static final int STATUS_ERROR = 0;
    private static int mStastus = 2;

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (action == null) {
            return;
        }
        RLog.i((Object)this, "Action", action);
        if ("io.rong.push.Connect".equals(action)) {
            if (PushContext.getInstance().isNewestVersion() && PushContext.getInstance().validateNetworkEnable()) {
                AppVersion version = PushContext.getInstance().getRunningPushServiceVersion();
                if (version == null) {
                    Intent connectIntent = new Intent(context, PushService.class);
                    connectIntent.setAction(action);
                    PushReceiver.startWakefulService((Context)context, (Intent)connectIntent);
                    RLog.i((Object)this, "CONNECT", "run connect");
                } else if (PushContext.getInstance().getCurrentVersion().getPushVersionCode() > version.getPushVersionCode()) {
                    Intent connectIntent = new Intent(context, PushService.class);
                    connectIntent.setAction(action);
                    PushReceiver.startWakefulService((Context)context, (Intent)connectIntent);
                    RLog.i((Object)this, "CONNECT", "run connect");
                }
            }
        } else if ("io.rong.push.StopHeartBeat".equals(action)) {
            Intent disConnectIntent = new Intent(context, PushService.class);
            Log.i((String)TAG, (String)"Receive heartbeat action.");
            disConnectIntent.setAction(action);
            PushReceiver.startWakefulService((Context)context, (Intent)disConnectIntent);
        } else if ("io.rong.push.HeartBeat".equals(action)) {
            Intent heartbeatIntent = new Intent(context, PushService.class);
            Log.i((String)TAG, (String)"Receive heartbeat action.");
            heartbeatIntent.setAction(action);
            PushReceiver.startWakefulService((Context)context, (Intent)heartbeatIntent);
        } else if ("android.net.conn.CONNECTIVITY_CHANGE".equals(action)) {
            int temp_status = -1;
            NetworkInfo.State wifi_state = null;
            NetworkInfo.State mobile_state = null;
            Log.i((String)TAG, (String)"Receive the network change message");
            ConnectivityManager ConnManager = (ConnectivityManager)context.getSystemService("connectivity");
            wifi_state = ConnManager.getNetworkInfo(1) == null ? null : ConnManager.getNetworkInfo(1).getState();
            mobile_state = ConnManager.getNetworkInfo(0) == null ? null : ConnManager.getNetworkInfo(0).getState();
            if (wifi_state != null && wifi_state == NetworkInfo.State.CONNECTED) {
                temp_status = 2;
                Log.i((String)TAG, (String)("mStatus is " + mStastus + ",the network has changed to be WIFI"));
            } else if (mobile_state != null && mobile_state == NetworkInfo.State.CONNECTED) {
                temp_status = 1;
                Log.i((String)TAG, (String)("mStatus is " + mStastus + ",the network has changed to be MOBILE"));
            } else {
                temp_status = 0;
                Log.i((String)TAG, (String)("mStatus is " + mStastus + ",the network has changed to be ERROR"));
            }
            if (temp_status != mStastus) {
                if (temp_status == 0) {
                    Log.i((String)TAG, (String)"No network! Stop the heart beat!!");
                    PushContext.getInstance().cancelHeartbeat();
                } else if (PushContext.getInstance().validateNeedSyncVersion()) {
                    PushContext.getInstance().sendSyncVersionCommand(context);
                } else {
                    PushContext.getInstance().sendConnectCommand(context, null);
                }
                Log.i((String)TAG, (String)"The network type has been changed.Notify the service to re-connect");
            } else {
                Log.i((String)TAG, (String)"The network is same as before, do nothing!!");
            }
            mStastus = temp_status;
        } else if ("io.rong.push.check_version".equals(action)) {
            Intent syncIntent = new Intent(context, CommandService.class);
            syncIntent.setAction("io.rong.push.check_version");
            PushReceiver.startWakefulService((Context)context, (Intent)syncIntent);
        }
    }
}

