/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.push;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class PushProtocalStack {
    PushProtocalStack() {
    }

    public static class FormatUtil {
        public static String dumpByteArray(byte[] bytes) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < bytes.length; ++i) {
                byte b = bytes[i];
                int iVal = b & 0xFF;
                int byteN = Integer.parseInt(Integer.toBinaryString(iVal));
                sb.append(String.format("%1$02d: %2$08d %3$1c %3$d\n", i, byteN, iVal));
            }
            return sb.toString();
        }

        public static byte[] toWMtpString(String s) {
            if (s == null) {
                return new byte[0];
            }
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(byteOut);
            try {
                dos.writeUTF(s);
                dos.flush();
            }
            catch (IOException e) {
                return new byte[0];
            }
            return byteOut.toByteArray();
        }

        public static String toString(byte[] data) {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            DataInputStream dis = new DataInputStream(bais);
            try {
                return dis.readUTF();
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }

    public static abstract class RetryableMessage
    extends Message {
        private int messageId;

        public RetryableMessage(Message.Header header) throws IOException {
            super(header);
        }

        public RetryableMessage(Message.Type type) {
            super(type);
        }

        @Override
        protected int messageLength() {
            return 2;
        }

        @Override
        protected void writeMessage(OutputStream out) throws IOException {
            int id2 = this.getMessageId();
            int lsb = id2 & 0xFF;
            int msb = (id2 & 0xFF00) >> 8;
            out.write(msb);
            out.write(lsb);
        }

        @Override
        protected void readMessage(InputStream in, int msgLength) throws IOException {
            int msgId = in.read() * 255 + in.read();
            this.setMessageId(msgId);
        }

        public void setMessageId(int messageId) {
            this.messageId = messageId;
        }

        public int getMessageId() {
            return this.messageId;
        }
    }

    public static enum QoS {
        AT_MOST_ONCE(0),
        AT_LEAST_ONCE(1),
        EXACTLY_ONCE(2),
        DEFAULT(3);

        public final int val;

        private QoS(int val) {
            this.val = val;
        }

        static QoS valueOf(int i) {
            for (QoS q : QoS.values()) {
                if (q.val != i) continue;
                return q;
            }
            throw new IllegalArgumentException("Not a valid QoS number: " + i);
        }
    }

    public static class PublishMessage
    extends RetryableMessage {
        private String topic;
        private byte[] data;
        private String targetId;
        private int date;

        public PublishMessage(Message.Header header) throws IOException {
            super(header);
        }

        @Override
        protected int messageLength() {
            return 0;
        }

        @Override
        protected void writeMessage(OutputStream out) throws IOException {
            super.writeMessage(out);
        }

        @Override
        protected void readMessage(InputStream in, int msgLength) throws IOException {
            int pos = 14;
            DataInputStream dis = new DataInputStream(in);
            dis.readLong();
            this.date = dis.readInt();
            this.topic = dis.readUTF();
            this.targetId = dis.readUTF();
            pos += FormatUtil.toWMtpString(this.topic).length;
            super.readMessage(in, msgLength);
            this.data = new byte[msgLength - (pos += FormatUtil.toWMtpString(this.targetId).length)];
            dis.read(this.data);
        }

        public String getTopic() {
            return this.topic;
        }

        public byte[] getData() {
            return this.data;
        }

        public int getServerTime() {
            return this.date;
        }

        public String getTargetId() {
            return this.targetId;
        }

        public String getDataAsString() {
            return FormatUtil.toString(this.data);
        }
    }

    public static class PingRespMessage
    extends Message {
        public PingRespMessage(Message.Header header) throws IOException {
            super(header);
        }

        public PingRespMessage() {
            super(Message.Type.PINGRESP);
        }
    }

    public static class PingReqMessage
    extends Message {
        public PingReqMessage() {
            super(Message.Type.PINGREQ);
        }

        public PingReqMessage(Message.Header header) throws IOException {
            super(header);
        }

        @Override
        public void setDup(boolean dup) {
            throw new UnsupportedOperationException("PINGREQ message does not support the DUP flag");
        }

        @Override
        public void setQos(QoS qos) {
            throw new UnsupportedOperationException("PINGREQ message does not support the QoS flag");
        }

        @Override
        public void setRetained(boolean retain) {
            throw new UnsupportedOperationException("PINGREQ message does not support the RETAIN flag");
        }
    }

    public static class MessageOutputStream {
        private final OutputStream out;

        public MessageOutputStream(OutputStream out) {
            this.out = out;
        }

        public void writeMessage(Message msg) throws IOException {
            msg.write(this.out);
            this.out.flush();
        }
    }

    public static class MessageInputStream
    implements Closeable {
        private InputStream in;

        public MessageInputStream(InputStream in) {
            this.in = in;
        }

        public Message readMessage() throws IOException {
            byte flags = (byte)this.in.read();
            Message.Header header = new Message.Header(flags);
            Message msg = null;
            if (header.getType() == null) {
                return null;
            }
            switch (header.getType()) {
                case CONNACK: {
                    msg = new ConnAckMessage(header);
                    break;
                }
                case PUBLISH: {
                    msg = new PublishMessage(header);
                    break;
                }
                case PINGRESP: {
                    msg = new PingRespMessage(header);
                    break;
                }
                case CONNECT: {
                    msg = new ConnectMessage(header);
                    break;
                }
                case PINGREQ: {
                    msg = new PingReqMessage(header);
                    break;
                }
                case DISCONNECT: {
                    msg = new DisconnectMessage(header);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("No support for deserializing " + (Object)((Object)header.getType()) + " messages");
                }
            }
            this.in.read();
            msg.read(this.in);
            return msg;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }

    public static abstract class Message {
        private final Header header;
        private byte headerCode;

        public Message(Type type) {
            this.header = new Header(type, false, QoS.AT_MOST_ONCE, false);
        }

        public Message(Header header) throws IOException {
            this.header = header;
        }

        final void read(InputStream in) throws IOException {
            int msgLength = this.readMsgLength(in);
            this.readMessage(in, msgLength);
        }

        public final void write(OutputStream out) throws IOException {
            this.headerCode = this.header.encode();
            out.write(this.headerCode);
            this.writeMsgCode(out);
            this.writeMsgLength(out);
            this.writeMessage(out);
        }

        private int readMsgLength(InputStream in) throws IOException {
            int digit;
            int msgLength = 0;
            int multiplier = 1;
            do {
                digit = in.read();
                msgLength += (digit & 0x7F) * multiplier;
                multiplier *= 128;
            } while ((digit & 0x80) > 0);
            return msgLength;
        }

        private void writeMsgLength(OutputStream out) throws IOException {
            int val = this.messageLength();
            do {
                byte b = (byte)(val & 0x7F);
                if ((val >>= 7) > 0) {
                    b = (byte)(b | 0x80);
                }
                out.write(b);
            } while (val > 0);
        }

        private void writeMsgCode(OutputStream out) throws IOException {
            int val = this.messageLength();
            int code = this.headerCode;
            do {
                byte b = (byte)(val & 0x7F);
                if ((val >>= 7) > 0) {
                    b = (byte)(b | 0x80);
                }
                code ^= b;
            } while (val > 0);
            out.write(code);
        }

        public final byte[] toBytes() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                this.write(baos);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return baos.toByteArray();
        }

        protected int messageLength() {
            return 0;
        }

        protected void writeMessage(OutputStream out) throws IOException {
        }

        protected void readMessage(InputStream in, int msgLength) throws IOException {
        }

        public void setRetained(boolean retain) {
            this.header.retain = retain;
        }

        public boolean isRetained() {
            return this.header.retain;
        }

        public void setQos(QoS qos) {
            this.header.qos = qos;
        }

        public QoS getQos() {
            return this.header.qos;
        }

        public void setDup(boolean dup) {
            this.header.dup = dup;
        }

        public boolean isDup() {
            return this.header.dup;
        }

        public Type getType() {
            return this.header.type;
        }

        public static class Header {
            private Type type;
            private boolean retain;
            private QoS qos = QoS.AT_MOST_ONCE;
            private boolean dup;

            private Header(Type type, boolean retain, QoS qos, boolean dup) {
                this.type = type;
                this.retain = retain;
                this.qos = qos;
                this.dup = dup;
            }

            public Header(byte flags) {
                this.retain = (flags & 1) > 0;
                this.qos = QoS.valueOf((flags & 6) >> 1);
                this.dup = (flags & 8) > 0;
                this.type = Type.valueOf(flags >> 4 & 0xF);
            }

            public Type getType() {
                return this.type;
            }

            private byte encode() {
                byte b = 0;
                b = (byte)(this.type.val << 4);
                b = (byte)(b | (this.retain ? (byte)1 : 0));
                b = (byte)(b | this.qos.val << 1);
                b = (byte)(b | (this.dup ? 8 : 0));
                return b;
            }

            public String toString() {
                return "Header [type=" + (Object)((Object)this.type) + ", retain=" + this.retain + ", qos=" + (Object)((Object)this.qos) + ", dup=" + this.dup + "]";
            }
        }

        public static enum Type {
            CONNECT(1),
            CONNACK(2),
            PUBLISH(3),
            PUBACK(4),
            QUERY(5),
            QUERYACK(6),
            QUERYCON(7),
            SUBSCRIBE(8),
            SUBACK(9),
            UNSUBSCRIBE(10),
            UNSUBACK(11),
            PINGREQ(12),
            PINGRESP(13),
            DISCONNECT(14);

            private final int val;

            private Type(int val) {
                this.val = val;
            }

            static Type valueOf(int i) {
                for (Type t : Type.values()) {
                    if (t.val != i) continue;
                    return t;
                }
                return null;
            }
        }
    }

    public static class DisconnectMessage
    extends Message {
        public static final int MESSAGE_LENGTH = 2;
        private DisconnectionStatus status;

        public DisconnectMessage(Message.Header header) throws IOException {
            super(header);
        }

        public DisconnectMessage(DisconnectionStatus status) {
            super(Message.Type.DISCONNECT);
            if (status == null) {
                throw new IllegalArgumentException("The status of ConnAskMessage can't be null");
            }
            this.status = status;
        }

        public DisconnectMessage() {
            super(Message.Type.DISCONNECT);
        }

        @Override
        protected int messageLength() {
            return 2;
        }

        @Override
        protected void readMessage(InputStream in, int msgLength) throws IOException {
            in.read();
            int result = in.read();
            switch (result) {
                case 0: {
                    this.status = DisconnectionStatus.RECONNECT;
                    break;
                }
                case 1: {
                    this.status = DisconnectionStatus.OTHER_DEVICE_LOGIN;
                    break;
                }
                case 2: {
                    this.status = DisconnectionStatus.CLOSURE;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported CONNACK code: " + result);
                }
            }
        }

        @Override
        protected void writeMessage(OutputStream out) throws IOException {
            out.write(0);
            switch (this.status) {
                case RECONNECT: {
                    out.write(0);
                    break;
                }
                case OTHER_DEVICE_LOGIN: {
                    out.write(1);
                    break;
                }
                case CLOSURE: {
                    out.write(2);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported CONNACK code: " + (Object)((Object)this.status));
                }
            }
        }

        public DisconnectionStatus getStatus() {
            return this.status;
        }

        @Override
        public void setDup(boolean dup) {
            throw new UnsupportedOperationException("DISCONNECT message does not support the DUP flag");
        }

        @Override
        public void setQos(QoS qos) {
            throw new UnsupportedOperationException("DISCONNECT message does not support the QoS flag");
        }

        @Override
        public void setRetained(boolean retain) {
            throw new UnsupportedOperationException("DISCONNECT message does not support the RETAIN flag");
        }

        public static enum DisconnectionStatus {
            RECONNECT,
            OTHER_DEVICE_LOGIN,
            CLOSURE;

        }
    }

    public static class ConnectMessage
    extends Message {
        private static int CONNECT_HEADER_SIZE = 12;
        private String protocolId = "MQIsdp";
        private byte protocolVersion = (byte)3;
        private String clientId;
        private int keepAlive;
        private String username;
        private String password;
        private boolean cleanSession;
        private String willTopic;
        private String will;
        private QoS willQoS;
        private boolean retainWill;
        private boolean hasUsername;
        private boolean hasPassword;
        private boolean hasWill;

        public ConnectMessage() {
            super(Message.Type.CONNECT);
        }

        public ConnectMessage(Message.Header header) throws IOException {
            super(header);
        }

        public ConnectMessage(String clientId, boolean cleanSession, int keepAlive) {
            super(Message.Type.CONNECT);
            if (clientId == null || clientId.length() > 64) {
                throw new IllegalArgumentException("Client id cannot be null and must be at most 64 characters long: " + clientId);
            }
            this.clientId = clientId;
            this.cleanSession = cleanSession;
            this.keepAlive = keepAlive;
        }

        @Override
        protected int messageLength() {
            int payloadSize = FormatUtil.toWMtpString(this.clientId).length;
            payloadSize += FormatUtil.toWMtpString(this.willTopic).length;
            payloadSize += FormatUtil.toWMtpString(this.will).length;
            payloadSize += FormatUtil.toWMtpString(this.username).length;
            return (payloadSize += FormatUtil.toWMtpString(this.password).length) + CONNECT_HEADER_SIZE;
        }

        @Override
        protected void readMessage(InputStream in, int msgLength) throws IOException {
            DataInputStream dis = new DataInputStream(in);
            this.protocolId = dis.readUTF();
            this.protocolVersion = dis.readByte();
            byte cFlags = dis.readByte();
            this.hasUsername = (cFlags & 0x80) > 0;
            this.hasPassword = (cFlags & 0x40) > 0;
            this.retainWill = (cFlags & 0x20) > 0;
            this.willQoS = QoS.valueOf(cFlags >> 3 & 3);
            this.hasWill = (cFlags & 4) > 0;
            this.cleanSession = (cFlags & 0x20) > 0;
            this.keepAlive = dis.read() * 256 + dis.read();
            this.clientId = dis.readUTF();
            if (this.hasWill) {
                this.willTopic = dis.readUTF();
                this.will = dis.readUTF();
            }
            if (this.hasUsername) {
                try {
                    this.username = dis.readUTF();
                }
                catch (EOFException e) {
                    // empty catch block
                }
            }
            if (this.hasPassword) {
                try {
                    this.password = dis.readUTF();
                }
                catch (EOFException e) {
                    // empty catch block
                }
            }
        }

        @Override
        protected void writeMessage(OutputStream out) throws IOException {
            DataOutputStream dos = new DataOutputStream(out);
            dos.writeUTF(this.protocolId);
            dos.write(this.protocolVersion);
            int flags = this.cleanSession ? 2 : 0;
            flags |= this.hasWill ? 4 : 0;
            flags |= this.willQoS == null ? 0 : this.willQoS.val << 3;
            flags |= this.retainWill ? 32 : 0;
            flags |= this.hasPassword ? 64 : 0;
            dos.write((byte)(flags |= this.hasUsername ? 128 : 0));
            dos.writeChar(this.keepAlive);
            dos.writeUTF(this.clientId);
            if (this.hasWill) {
                dos.writeUTF(this.willTopic);
                dos.writeUTF(this.will);
            }
            if (this.hasUsername) {
                dos.writeUTF(this.username);
            }
            if (this.hasPassword) {
                dos.writeUTF(this.password);
            }
            dos.flush();
        }

        public void setCredentials(String username) {
            this.setCredentials(username, null);
        }

        public void setCredentials(String username, String password) {
            if ((username == null || username.isEmpty()) && password != null && !password.isEmpty()) {
                throw new IllegalArgumentException("It is not valid to supply a password without supplying a username.");
            }
            this.username = username;
            this.password = password;
            this.hasUsername = this.username != null;
            this.hasPassword = this.password != null;
        }

        public void setWill(String willTopic, String will) {
            this.setWill(willTopic, will, QoS.AT_MOST_ONCE, false);
        }

        public void setWill(String willTopic, String will, QoS willQoS, boolean retainWill) {
            if (willTopic == null ^ will == null || will == null ^ willQoS == null) {
                throw new IllegalArgumentException("Can't set willTopic, will or willQoS value independently");
            }
            this.willTopic = willTopic;
            this.will = will;
            this.willQoS = willQoS;
            this.retainWill = retainWill;
            this.hasWill = willTopic != null;
        }

        @Override
        public void setDup(boolean dup) {
            throw new UnsupportedOperationException("CONNECT messages don't use the DUP flag.");
        }

        @Override
        public void setRetained(boolean retain) {
            throw new UnsupportedOperationException("CONNECT messages don't use the RETAIN flag.");
        }

        @Override
        public void setQos(QoS qos) {
            throw new UnsupportedOperationException("CONNECT messages don't use the QoS flags.");
        }

        public String getProtocolId() {
            return this.protocolId;
        }

        public byte getProtocolVersion() {
            return this.protocolVersion;
        }

        public String getClientId() {
            return this.clientId;
        }

        public int getKeepAlive() {
            return this.keepAlive;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean isCleanSession() {
            return this.cleanSession;
        }

        public String getWillTopic() {
            return this.willTopic;
        }

        public String getWill() {
            return this.will;
        }

        public QoS getWillQoS() {
            return this.willQoS;
        }

        public boolean isWillRetained() {
            return this.retainWill;
        }

        public boolean hasUsername() {
            return this.hasUsername;
        }

        public boolean hasPassword() {
            return this.hasPassword;
        }

        public boolean hasWill() {
            return this.hasWill;
        }
    }

    public static class ConnAckMessage
    extends Message {
        public static final int MESSAGE_LENGTH = 2;
        private ConnectionStatus status;
        private String userId;

        public ConnAckMessage() {
            super(Message.Type.CONNACK);
        }

        public ConnAckMessage(Message.Header header) throws IOException {
            super(header);
        }

        public ConnAckMessage(ConnectionStatus status) {
            super(Message.Type.CONNACK);
            if (status == null) {
                throw new IllegalArgumentException("The status of ConnAskMessage can't be null");
            }
            this.status = status;
        }

        @Override
        protected int messageLength() {
            int length = 2;
            if (this.userId != null && !this.userId.isEmpty()) {
                length += FormatUtil.toWMtpString(this.userId).length;
            }
            return length;
        }

        @Override
        protected void readMessage(InputStream in, int msgLength) throws IOException {
            in.read();
            int result = in.read();
            switch (result) {
                case 0: {
                    this.status = ConnectionStatus.ACCEPTED;
                    break;
                }
                case 1: {
                    this.status = ConnectionStatus.UNACCEPTABLE_PROTOCOL_VERSION;
                    break;
                }
                case 2: {
                    this.status = ConnectionStatus.IDENTIFIER_REJECTED;
                    break;
                }
                case 3: {
                    this.status = ConnectionStatus.SERVER_UNAVAILABLE;
                    break;
                }
                case 4: {
                    this.status = ConnectionStatus.BAD_USERNAME_OR_PASSWORD;
                    break;
                }
                case 5: {
                    this.status = ConnectionStatus.NOT_AUTHORIZED;
                    break;
                }
                case 6: {
                    this.status = ConnectionStatus.REDIRECT;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported CONNACK code: " + result);
                }
            }
            if (msgLength > 2) {
                DataInputStream dis = new DataInputStream(in);
                this.userId = dis.readUTF();
            }
        }

        @Override
        protected void writeMessage(OutputStream out) throws IOException {
            out.write(0);
            switch (this.status) {
                case ACCEPTED: {
                    out.write(0);
                    break;
                }
                case UNACCEPTABLE_PROTOCOL_VERSION: {
                    out.write(1);
                    break;
                }
                case IDENTIFIER_REJECTED: {
                    out.write(2);
                    break;
                }
                case SERVER_UNAVAILABLE: {
                    out.write(3);
                    break;
                }
                case BAD_USERNAME_OR_PASSWORD: {
                    out.write(4);
                    break;
                }
                case NOT_AUTHORIZED: {
                    out.write(5);
                    break;
                }
                case REDIRECT: {
                    out.write(6);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported CONNACK code: " + (Object)((Object)this.status));
                }
            }
            if (this.userId != null && !this.userId.isEmpty()) {
                DataOutputStream dos = new DataOutputStream(out);
                dos.writeUTF(this.userId);
                dos.flush();
            }
        }

        public ConnectionStatus getStatus() {
            return this.status;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getUserId() {
            return this.userId;
        }

        @Override
        public void setDup(boolean dup) {
            throw new UnsupportedOperationException("CONNACK messages don't use the DUP flag.");
        }

        @Override
        public void setRetained(boolean retain) {
            throw new UnsupportedOperationException("CONNACK messages don't use the RETAIN flag.");
        }

        @Override
        public void setQos(QoS qos) {
            throw new UnsupportedOperationException("CONNACK messages don't use the QoS flags.");
        }

        public static enum ConnectionStatus {
            ACCEPTED,
            UNACCEPTABLE_PROTOCOL_VERSION,
            IDENTIFIER_REJECTED,
            SERVER_UNAVAILABLE,
            BAD_USERNAME_OR_PASSWORD,
            NOT_AUTHORIZED,
            REDIRECT;

        }
    }
}

