/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.push;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import io.rong.imlib.notification.RongNotificationManager;
import io.rong.imlib.notification.RongNotificationMessage;
import io.rong.imlib.push.PushContext;

public class PushMessageReceiver
extends BroadcastReceiver {
    private static final String TAG = "PushMsgReceiver";

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        Log.i((String)TAG, (String)("onReceive.the intent is: " + intent));
        if (intent.getAction().equals("io.rong.push.message")) {
            Bundle bundle = intent.getExtras();
            RongNotificationMessage notiMsg = new RongNotificationMessage.Builder().setNotiMsgObjType(bundle.getString("objectName")).setNotiMsgUserId(bundle.getString("fromUserId")).setNotiMsgUserName(bundle.getString("fromUserName")).setNotiMsgTitle(bundle.getString("title")).setNotiMsgContent(bundle.getString("content")).setNotiMsgChannelId(bundle.getString("channelId")).setNotiMsgChannelName(bundle.getString("channelName")).setNotiMsgChannelType(bundle.getString("channelType")).build();
            if (this.isValidPushMsg(bundle)) {
                if (notiMsg.getObjName().indexOf("Voip") > 0) {
                    this.startVoIP(context, bundle);
                } else if (!notiMsg.getObjName().equals("RC:StatusMessage")) {
                    RongNotificationManager.getInstance().receiveNewNotificationMsg(notiMsg);
                }
            }
        }
    }

    public boolean isValidPushMsg(Bundle bundle) {
        boolean result = false;
        String appId = bundle.getString("appId");
        if (appId.equals(PushContext.getInstance().getCurrentVersion().getAppKey())) {
            result = true;
        }
        Log.i((String)TAG, (String)("isValidPushMsg. result:" + result));
        return result;
    }

    private void startVoIP(Context context, Bundle bundle) {
        Intent intent = new Intent();
        String appName = context.getPackageName();
        Uri uri = Uri.parse((String)("rong://" + appName)).buildUpon().appendPath("calledsideactivity").build();
        intent.setData(uri);
        intent.setAction("io.rong.voipkit.calledSideActivity.action");
        intent.putExtra("appId", bundle.getString("appId"));
        intent.putExtra("push", true);
        intent.putExtra("fromUserPhoneUri", bundle.getString("fromUserPo"));
        intent.putExtra("fromUserName", bundle.getString("fromUserName"));
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }
}

