/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.push;

import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import com.sea_monster.core.network.DefaultHttpHandler;
import com.sea_monster.core.network.HttpHandler;
import de.greenrobot.dao.query.WhereCondition;
import io.rong.database.Version;
import io.rong.database.VersionDao;
import io.rong.imlib.IVersionHandler;
import io.rong.imlib.common.RLog;
import io.rong.imlib.common.RongVersionDatabase;
import io.rong.imlib.model.AppVersion;
import io.rong.imlib.push.PushReceiver;
import io.rong.imlib.push.PushService;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class PushContext
extends ContextWrapper {
    Handler mWorkHandler;
    static PushContext sS;
    AppVersion mVersion;
    AppVersion mNewestVersion;
    HttpHandler mHttpHandler;
    int mPackageValidateCode;
    int mVersionValidateCode;

    public static PushContext getInstance() {
        return sS;
    }

    public static void init(Context context) {
        sS = new PushContext(context);
    }

    public PushContext(Context base) {
        super(base);
        RongVersionDatabase.init((Context)this);
        HandlerThread thread = new HandlerThread("IPCHandler");
        thread.start();
        this.mWorkHandler = new Handler(thread.getLooper());
        PriorityBlockingQueue<Runnable> workQueue = new PriorityBlockingQueue<Runnable>(25);
        ThreadFactory mThreadFactory = new ThreadFactory(){
            private final AtomicInteger mCount = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "ConnectTask #" + this.mCount.getAndIncrement());
            }
        };
        ThreadPoolExecutor executor = new ThreadPoolExecutor(2, 3, 1L, TimeUnit.SECONDS, workQueue, mThreadFactory);
        this.mHttpHandler = new DefaultHttpHandler((Context)this, executor);
        try {
            this.mVersion = new AppVersion(base);
            RongVersionDatabase.getVersionDao().insertOrReplace(this.mVersion);
        }
        catch (PackageManager.NameNotFoundException e) {
            RLog.w((Object)this, "init", e);
        }
        this.initValidateCode();
        if (this.validateNeedSyncVersion()) {
            this.sendSyncVersionCommand((Context)this);
        } else if (this.isNewestVersion() && this.validateNetworkEnable()) {
            AppVersion version = this.getRunningPushServiceVersion();
            if (version == null) {
                this.sendConnectCommand((Context)this, null);
            } else if (this.getCurrentVersion().getPushVersionCode() > version.getPushVersionCode()) {
                this.sendConnectCommand((Context)this, null);
            }
        }
    }

    public HttpHandler getHttpHandler() {
        return this.mHttpHandler;
    }

    private void initValidateCode() {
        List versions = RongVersionDatabase.getVersionDao().queryBuilder().orderAsc(VersionDao.Properties.AppId).list();
        StringBuilder builder = new StringBuilder();
        if (versions == null || versions.size() == 0) {
            return;
        }
        StringBuilder versionBuilder = new StringBuilder();
        for (Version version : versions) {
            builder.append(version.getAppId());
            versionBuilder.append(version.getAppKey()).append(version.getAppVersionCode());
        }
        this.mPackageValidateCode = builder.toString().hashCode();
        this.mVersionValidateCode = versionBuilder.toString().hashCode();
        Version version = (Version)RongVersionDatabase.getVersionDao().queryBuilder().orderDesc(VersionDao.Properties.PushVersionCode, VersionDao.Properties.SDKVersionCode, VersionDao.Properties.AppId).limit(1).unique();
        if (version != null) {
            this.mNewestVersion = new AppVersion(version);
        }
    }

    public int getPackageValidateCode() {
        return this.mPackageValidateCode;
    }

    public int getVersionValidateCode() {
        return this.mVersionValidateCode;
    }

    public void startPushService(Context context) {
        Intent intent = new Intent(context, PushReceiver.class);
        intent.setPackage(context.getPackageName());
        this.sendBroadcast(intent);
    }

    public void startNextHeartbeat(long nextIntervalMillis) {
        Intent intent = new Intent((Context)this, PushReceiver.class);
        RLog.i((Object)this, "Heartbeat", "start_next");
        AlarmManager mAlarmMng = (AlarmManager)this.getSystemService("alarm");
        intent.setAction("io.rong.push.HeartBeat");
        PendingIntent mPendingIntent = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)intent, (int)0);
        mAlarmMng.cancel(mPendingIntent);
        mAlarmMng.set(3, SystemClock.elapsedRealtime() + nextIntervalMillis, mPendingIntent);
    }

    public void cancelHeartbeat() {
        Intent intent = new Intent((Context)this, PushReceiver.class);
        RLog.i((Object)this, "Heartbeat", "cancel");
        AlarmManager mAlarmMng = (AlarmManager)this.getSystemService("alarm");
        intent.setAction("io.rong.push.HeartBeat");
        PendingIntent mPendingIntent = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)intent, (int)0);
        mAlarmMng.cancel(mPendingIntent);
    }

    public void syncVersion() {
        if (Thread.currentThread().equals(this.getMainLooper().getThread())) {
            throw new RuntimeException("CheckEnv Cannot Run at mainThread");
        }
        PackageManager packageManager = this.getPackageManager();
        Intent checkIntent = new Intent("io.rong.command");
        List infos = packageManager.queryIntentServices(checkIntent, 64);
        List versions = RongVersionDatabase.getVersionDao().loadAll();
        HashMap<String, Object> versionMap = new HashMap<String, Object>();
        for (Object item : versions) {
            versionMap.put(((Version)item).getAppId(), item);
        }
        ArrayList<ApplicationInfo> infoList = new ArrayList<ApplicationInfo>();
        for (Object info : infos) {
            try {
                ApplicationInfo applicationInfo = packageManager.getApplicationInfo(((ResolveInfo)info).serviceInfo.packageName, 128);
                PackageInfo packageInfo = packageManager.getPackageInfo(((ResolveInfo)info).serviceInfo.packageName, 0);
                if (versionMap.containsKey(applicationInfo.packageName)) {
                    Version version = (Version)versionMap.get(applicationInfo.packageName);
                    if (!version.getAppKey().equals(applicationInfo.metaData.getString("RongCloud")) || version.getAppVersionCode() < packageInfo.versionCode) {
                        infoList.add(applicationInfo);
                    }
                    versionMap.remove(applicationInfo.packageName);
                } else {
                    infoList.add(applicationInfo);
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            RLog.d((Object)this, "Push_Sync", ((ResolveInfo)info).serviceInfo.packageName);
        }
        if (infoList.size() > 0) {
            CountDownLatch count = new CountDownLatch(infoList.size());
            for (ApplicationInfo info : infoList) {
                RLog.d((Object)this, "SYNC-BIND", info.packageName);
                Intent commandService = new Intent("io.rong.command");
                commandService.setPackage(info.packageName);
                this.bindService(commandService, new ServiceConnectionListener(info.packageName, count), 1);
            }
            try {
                if (count.getCount() > 0L) {
                    count.await();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (versionMap.size() > 0) {
            for (Version version : versionMap.values()) {
                RongVersionDatabase.getVersionDao().delete(version);
            }
        }
        this.initValidateCode();
    }

    public AppVersion getNewestVersion() {
        return this.mNewestVersion;
    }

    public boolean isNewestVersion() {
        if (this.mVersion == null) {
            return false;
        }
        return this.mVersion.getPushVersionCode() >= this.mNewestVersion.getPushVersionCode();
    }

    public AppVersion getCurrentVersion() {
        return this.mVersion;
    }

    public AppVersion getRunningPushServiceVersion() {
        ActivityManager manager = (ActivityManager)this.getSystemService("activity");
        List runningServiceInfos = manager.getRunningServices(Integer.MAX_VALUE);
        for (ActivityManager.RunningServiceInfo info : runningServiceInfos) {
            if (info.service.getPackageName().equals(this.getPackageName()) || !info.service.getClassName().equals(PushService.class.getName())) continue;
            RLog.i((Object)this, "RUNNING_PUSH", info.service.getClassName() + ":" + info.service.getPackageName());
            Version version = (Version)RongVersionDatabase.getVersionDao().queryBuilder().where(VersionDao.Properties.AppId.eq(info.service.getPackageName()), new WhereCondition[0]).unique();
            return new AppVersion(version);
        }
        return null;
    }

    public boolean hasNetworkInfo() {
        ConnectivityManager mConnectivity = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo info = mConnectivity.getActiveNetworkInfo();
        return info != null;
    }

    public void sendSyncVersionCommand(Context context) {
        Intent intent = new Intent((Context)this, PushReceiver.class);
        intent.setAction("io.rong.push.check_version");
        intent.setPackage(this.getPackageName());
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        alarmManager.cancel(pendingIntent);
        int random = new Random().nextInt(50) * 100;
        alarmManager.set(3, SystemClock.elapsedRealtime() + (long)random, pendingIntent);
        RLog.i((Object)this, "sendSyncVersionCommand", random + "");
    }

    public void sendConnectCommand(Context context, String packageName) {
        Intent intent = new Intent((Context)this, PushReceiver.class);
        intent.setAction("io.rong.push.Connect");
        intent.setPackage(TextUtils.isEmpty((CharSequence)packageName) ? null : this.getPackageName());
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        alarmManager.cancel(pendingIntent);
        int random = new Random().nextInt(50) * 100;
        alarmManager.set(3, SystemClock.elapsedRealtime() + (long)random, pendingIntent);
        RLog.i((Object)this, "sendConnectCommand", random + "");
    }

    public boolean validateNeedSyncVersion() {
        PackageManager packageManager = this.getPackageManager();
        Intent checkIntent = new Intent("io.rong.command");
        List infos = packageManager.queryIntentServices(checkIntent, 64);
        Collections.sort(infos, new Comparator<ResolveInfo>(){
            private final Collator mCollator = Collator.getInstance();

            @Override
            public int compare(ResolveInfo lhs, ResolveInfo rhs) {
                return this.mCollator.compare(lhs.serviceInfo.packageName, rhs.serviceInfo.packageName);
            }
        });
        StringBuilder stringBuilder = new StringBuilder();
        for (ResolveInfo info : infos) {
            stringBuilder.append(info.serviceInfo.packageName);
        }
        if (this.getPackageValidateCode() != stringBuilder.toString().hashCode()) {
            return true;
        }
        stringBuilder = new StringBuilder();
        for (ResolveInfo info : infos) {
            try {
                ApplicationInfo applicationInfo = packageManager.getApplicationInfo(info.serviceInfo.packageName, 128);
                PackageInfo packageInfo = packageManager.getPackageInfo(info.serviceInfo.packageName, 0);
                stringBuilder.append(applicationInfo.metaData.getString("RongCloud")).append(packageInfo.versionCode);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return this.getVersionValidateCode() != stringBuilder.toString().hashCode();
    }

    public boolean validateNetworkEnable() {
        NetworkInfo info;
        ConnectivityManager connectivity = (ConnectivityManager)this.getSystemService("connectivity");
        return connectivity != null && (info = connectivity.getActiveNetworkInfo()) != null && info.isConnected() && info.getState() == NetworkInfo.State.CONNECTED;
    }

    class ServiceConnectionListener
    implements ServiceConnection {
        IVersionHandler mHandler;
        boolean mIsBind;
        String packageName;
        CountDownLatch count;

        public ServiceConnectionListener(String packageName, CountDownLatch count) {
            this.packageName = packageName;
            this.count = count;
        }

        public IVersionHandler getHandler() {
            return this.mHandler;
        }

        public boolean isBind() {
            return this.mIsBind;
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            RLog.i(this, "onServiceConnected", name.toString());
            this.mHandler = IVersionHandler.Stub.asInterface(service);
            this.mIsBind = true;
            PushContext.this.mWorkHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        AppVersion version = ServiceConnectionListener.this.mHandler.getVersion();
                        RongVersionDatabase.getVersionDao().insertOrReplace(version);
                        PushContext.this.unbindService(ServiceConnectionListener.this);
                        ServiceConnectionListener.this.count.countDown();
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        ServiceConnectionListener.this.count.countDown();
                    }
                }
            });
        }

        public void onServiceDisconnected(ComponentName name) {
            RLog.i(this, "onServiceDisconnected", name.toString());
            this.mHandler = null;
            this.mIsBind = false;
        }
    }

    public static enum Status {
        CONNECTED,
        DISCONNECTED,
        SYNC_VERSION;

    }
}

