/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.push;

import android.util.Log;
import io.rong.imlib.common.RLog;
import io.rong.imlib.push.PushProtocalStack;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Semaphore;

class PushClient {
    private PushProtocalStack.MessageInputStream in;
    private Socket socket;
    private PushProtocalStack.MessageOutputStream out;
    public OutputStream os;
    private PushReader reader;
    private Semaphore connectionAckLock;
    private ClientListener listener;
    private PushProtocalStack.ConnectMessage connectMsg;
    private ConnectStatusCallback connectCallback;
    private PingSuccessListener mPingSuccessListener;

    public PushClient(String clientId, String appkey, String token, ClientListener listener, PingSuccessListener mPingSuccessListener) {
        this.listener = listener;
        this.mPingSuccessListener = mPingSuccessListener;
        this.connectMsg = new PushProtocalStack.ConnectMessage(clientId, true, 300);
        this.connectMsg.setCredentials(appkey, token);
        this.connectMsg.setWill("clientInfo", String.format("%s-%s-%s", "testClient", "1.0", "1.0"));
    }

    public void connect(String host, int port, ConnectStatusCallback callback) throws IOException, InterruptedException {
        SocketChannel socketChannel = SocketChannel.open();
        this.socket = new Socket();
        InetSocketAddress address = new InetSocketAddress(host, port);
        this.socket.connect(address, 4000);
        InputStream is = this.socket.getInputStream();
        this.in = new PushProtocalStack.MessageInputStream(is);
        this.os = this.socket.getOutputStream();
        this.out = new PushProtocalStack.MessageOutputStream(this.os);
        this.reader = new PushReader();
        this.reader.start();
        this.connectCallback = callback;
        this.connectionAckLock = new Semaphore(0);
        this.out.writeMessage(this.connectMsg);
        this.connectionAckLock.acquire();
    }

    public void ping() throws IOException {
        if (this.socket != null && this.socket.isConnected() && this.out != null) {
            RLog.i(this, "Ping", this.socket.getInetAddress().toString());
            this.out.writeMessage(new PushProtocalStack.PingReqMessage());
            if (this.mPingSuccessListener != null) {
                this.mPingSuccessListener.onSuccess();
            }
        }
    }

    public void disconnect() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public void disconnectByNormal() {
        PushProtocalStack.DisconnectMessage msg = new PushProtocalStack.DisconnectMessage(PushProtocalStack.DisconnectMessage.DisconnectionStatus.CLOSURE);
        if (this.out == null || this.socket == null) {
            return;
        }
        try {
            this.out.writeMessage(msg);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void handleMessage(PushProtocalStack.Message msg) throws IOException {
        if (msg == null) {
            return;
        }
        RLog.i(this, "Handler", (Object)((Object)msg.getType()) + "");
        switch (msg.getType()) {
            case CONNACK: {
                this.connectionAckLock.release();
                if (this.connectCallback == null) break;
                PushProtocalStack.ConnAckMessage connAckMsg = (PushProtocalStack.ConnAckMessage)msg;
                this.connectCallback.onConnected(connAckMsg);
                break;
            }
            case PINGRESP: {
                if (this.mPingSuccessListener == null) break;
                this.mPingSuccessListener.onSuccess();
                break;
            }
            case PUBLISH: {
                PushProtocalStack.PublishMessage publishMsg = (PushProtocalStack.PublishMessage)msg;
                if (this.listener == null) break;
                Log.i((String)"PushClient", (String)"call Publish msg listener");
                this.listener.messageArrived(publishMsg);
                break;
            }
        }
    }

    public static interface PingSuccessListener {
        public void onSuccess();

        public void onFailure();
    }

    public static interface ConnectStatusCallback {
        public void onConnected(PushProtocalStack.ConnAckMessage var1) throws IOException;

        public void onDisconnected(IOException var1);
    }

    public static interface ClientListener {
        public void messageArrived(PushProtocalStack.PublishMessage var1);
    }

    private class PushReader
    extends Thread {
        private PushReader() {
        }

        @Override
        public void run() {
            PushProtocalStack.Message msg = null;
            try {
                while (true) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (PushClient.this.in != null) {
                        msg = PushClient.this.in.readMessage();
                    }
                    if (msg == null) continue;
                    PushClient.this.handleMessage(msg);
                }
            }
            catch (IOException e) {
                if (PushClient.this.connectCallback != null) {
                    PushClient.this.connectCallback.onDisconnected(e);
                }
                return;
            }
        }
    }
}

