/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.push;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteException;
import io.rong.imlib.IVersionHandler;
import io.rong.imlib.common.RLog;
import io.rong.imlib.common.RongVersionDatabase;
import io.rong.imlib.model.AppVersion;
import io.rong.imlib.notification.RongNotificationManager;
import io.rong.imlib.push.PushContext;

public class CommandService
extends IntentService {
    IVersionHandler.Stub mStub = new IVersionHandler.Stub(){

        @Override
        public AppVersion getVersion() throws RemoteException {
            RLog.i(this, "Stub", "getVersion");
            if (PushContext.getInstance() == null) {
                throw new RuntimeException("RongCloudSDK is not init");
            }
            return PushContext.getInstance().getCurrentVersion();
        }
    };

    public CommandService() {
        super("RongCommandService");
    }

    public void onCreate() {
        super.onCreate();
        if (PushContext.getInstance() == null) {
            PushContext.init((Context)this);
            RongVersionDatabase.init((Context)this);
            RongNotificationManager.init((Context)this);
        }
    }

    public IBinder onBind(Intent intent) {
        RLog.i((Object)this, "onBind", intent.toString());
        return this.mStub;
    }

    protected void onHandleIntent(Intent intent) {
        if (intent == null || intent.getAction() == null) {
            return;
        }
        if (intent.getAction().equals("io.rong.push.check_version")) {
            PushContext.getInstance().syncVersion();
            if (PushContext.getInstance().isNewestVersion() && PushContext.getInstance().validateNetworkEnable()) {
                AppVersion runVersion = PushContext.getInstance().getRunningPushServiceVersion();
                if (runVersion == null) {
                    RLog.i((Object)this, "SYNC_CONNECT", "getRunningPushServiceVersion null");
                    PushContext.getInstance().sendConnectCommand((Context)this, null);
                } else {
                    RLog.i((Object)this, "SYNC_CONNECT", runVersion.getAppId() + ":" + runVersion.getPushVersionCode());
                }
            }
        }
    }
}

